{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit qConn;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils,
  Classes,  Graphics, Controls, Forms,
  Dialogs,  StdCtrls, xForms;

type
  TfQuickConnect = class(TxForm)
    HostName: TComboBox;
    Port: TComboBox;
    Definition: TComboBox;
    LHostName: TLabel;
    LPort: TLabel;
    LDefinition: TLabel;
    btnConnect: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnConnectClick(Sender: TObject);
  private
    LastDefinition : String;
    LastHostName   : String;
    LastPort       : String;
    { Private declarations }
  public
    { Public declarations }
    constructor Create(aOwner:TComponent); override;
    destructor Destroy; override;
    function WriteINI:Boolean; override;
    function ReadINI:Boolean; override;
    function ReadMSG:Boolean; override;
  end;

var
  fQuickConnect: TfQuickConnect;

implementation
{$R *.DFM}
Uses
  STConfig, kUnits, Main, MSGLib;
Const
  ctNoDefinition : String = 'ctNoDefinition';
  ctLastHostName   = 'HostName';
  ctHostNameHistory= 'HostName.History.%d';
  ctLastPort       = 'Port';
  ctPortHistory    = 'Port.History.%d';
  ctLastDefinition = 'Definition';

Constructor TfQuickConnect.Create(aOwner:TComponent);
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuQuickConnect, 'TfQuickConnect.Create', 'Begin');{$ENDIF}
  inherited Create(aOwner);

  Name           := 'fQuickConnect';
  SavePosition   := True;

  LastHostName := '';
  LastPort := '';
  LastDefinition := '';

  ReadINI;

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuQuickConnect, 'TfQuickConnect.Create', 'End');{$ENDIF}
End;

Destructor TfQuickConnect.Destroy;
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuQuickConnect, 'TfQuickConnect.Destroy', 'Begin');{$ENDIF}
  WriteINI;

  inherited Destroy;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuQuickConnect, 'TfQuickConnect.Destroy', 'End');{$ENDIF}
end;

procedure TfQuickConnect.FormShow(Sender: TObject);
begin
  { V pripade, ze neni nadefinovano zadne spojeni, akce je zrusena a je vyvolan
    dialog na 'SelectConnection' pomoci ktereho muze uzivatel vytvorit ... }
  If not (CFG^.Connections.Count>0) Then Begin
    Application.MessageBox(@ctNoDefinition[1], @ctError[1], MB_ICONSTOP or MB_OK);
    PostMessage(Handle, WM_CLOSE, 0, 0);
    PostMessage(TfMain(CFG^.Windows.Items[0]).Handle, MSG_SELECTCONN, 0, 0);
  End;
  { Jmena predefinovanych spojeni se prevezmou z globalni konfigurace a neni
    mozne je upravovat }
  STConfig.ConnectionMakeList(Definition.Items);
  { Jestlize neni v seznamu presne to co tam bylo minule najde se to co
    je nejpodobnejsi }
  Definition.ItemIndex:=StringsFindNearest(Definition.Items, LastDefinition, False);
  HostName.ItemIndex:=StringsFindNearest(HostName.Items, LastHostName, False);
  Port.ItemIndex:=StringsFindNearest(Port.Items, LastPort, False);
end;

procedure TfQuickConnect.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
 If Key=VK_ESCAPE Then Close;
end;

function TfQuickConnect.WriteINI:Boolean;
Var
  I:Integer;
Begin
  Result := Inherited WriteINI;
  If Result Then Begin
    FINIFile^.WriteString(iName, ctLastHostName, LastHostName);
    For I:=0 To HostName.Items.Count-1 Do
      FINIFile^.WriteString(iName, Format(ctHostNameHistory, [I]), HostName.Items[I]);

    FINIFile^.WriteString(iName, ctLastPort, LastPort);
    For I:=0 To Port.Items.Count-1 Do
      FINIFile^.WriteString(iName, Format(ctPortHistory, [I]), Port.Items[I]);

    FINIFile^.WriteString(iName, ctLastDefinition, LastDefinition);
  End;
End;

function TfQuickConnect.ReadINI:Boolean;
Var
  I : Integer;
  S : String;
Begin
  Result := Inherited ReadINI;
  If Result Then Begin
    LastHostName := FINIFile^.ReadString(iName, ctLastHostName, LastHostName);
    I:=0; While True Do Begin
      S:=FINIFile^.ReadString(iName, Format(ctHostNameHistory, [I]), '');
      If S<>'' Then Begin
        If HostName.Items.IndexOf(S)=-1 Then HostName.Items.Add(S)
      End Else Break;
      Inc(I);
    End;

    LastPort := FINIFile^.ReadString(iName, ctLastPort, LastPort);
    I:=0; While True Do Begin
      S:=FINIFile^.ReadString(iName, Format(ctPortHistory, [I]), '');
      If S<>'' Then Begin
        If Port.Items.IndexOf(S)=-1 Then Port.Items.Add(S)
      End Else Break;
      Inc(I);
    End;

    LastDefinition := FINIFile^.ReadString(iName, ctLastDefinition, LastDefinition);
  End;
End;

function TfQuickConnect.ReadMSG:Boolean;
Begin
  Result:=Inherited ReadMSG;
  If Result Then
    ctNoDefinition := ReadMSGString('NoDefinition');
End;

procedure TfQuickConnect.btnConnectClick(Sender: TObject);
begin
  If HostName.Text<>'' Then Begin
    { Zkontrolovat jestli zadany retezec v historii }
    If HostName.Items.IndexOf(HostName.Text)=-1 Then HostName.Items.Add(HostName.Text);
    { Posunout v historii prave pouzite polozky na zacatek }
    HostName.Items.Move(HostName.Items.IndexOf(HostName.Text), 0);
  End;

  If Port.Text<>'' Then Begin
    If Port.Items.IndexOf(Port.Text)=-1 Then Port.Items.Add(Port.Text);
    Port.Items.Move(Port.Items.IndexOf(Port.Text), 0);
  End;

  { Zapamatovat si co uzivatel naposledy vybral }
  LastHostName := HostName.Text;
  LastPort := Port.Text;
  LastDefinition := Definition.Text;
end;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuQuickConnect, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuQuickConnect, 'finalization', '');{$ENDIF}{$ENDIF}
end.

