{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version : 0.903
Date    : 28.08.98
Dialog  : Connection parameters
History :
  01.05.98 QC
  10.05.98 Odstraneny problemy s velikosti fontu
             Inteligententnejsi vybirani ze seznamu fce StringsFindNearest
  21.05.98 Pridano lokalni echo, line mode
  08.07.98 Korektni nastovani znakove konverze video/printer
  23.08.98 Vycty fontu se provadeji v knihovne C3216, smazana prislusna
           funkce ktera zde byla lokalni. Platne velikosti fontu jsou
           serazeny.
  28.08.98 Pridana kontrola prav uzivate pro nove vlastnosti
  26.01.99 Podpora BOLD font face !
TODO    :
-------------------------------------------------------------------------------}

unit ConnPar;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,  Graphics,
  Controls, Forms,    Dialogs,  Grids,    Outline,  ExtCtrls,
  StdCtrls, RXSpin,   RXCtrls,  Mask,     ToolEdit, RXCombos,
  xForms,   Menus,    Printers, STConfig;

type
  TfConnectionParameters = class(TxForm)
    {OptionTree window  .......................................................}
    pnOptionTree         : TPanel;
    pnOptionTreeInner    : TPanel;
    OptionTree           : TOutline;
    {Main window ..............................................................}
    pnMain               : TPanel;
    Notebook             : TNotebook;
    {Main window - Conection ..................................................}
    pnConnection         : TPanel;
    cbConnection         : TCheckBox;
    gbConnection         : TGroupBox;
    Host                 : TEdit;
    LHost                : TLabel;
    Port                 : TComboBox;
    LPort                : TLabel;
    ConnectionCaption    : TEdit;
    LCaption             : TLabel;
    TerminalType         : TComboBox;
    LTerminalType        : TLabel;
    {Main window - CharSet ....................................................}
    pnCharSet            : TPanel;
    cbCharSet            : TCheckBox;
    gbCharSet            : TGroupBox;
    CharSetEnc           : TCheckBox;
    HostCP               : TComboBox;
    LHostCP              : TLabel;
    LocalCP              : TComboBox;
    LLocalCP             : TLabel;
    LSemigraphicsCP: TLabel;
    SemigraphicsCP: TComboBox;
    KeybCharSetCheckBox  : TCheckBox;
    KeybCharSet          : TComboBox;
    {Main window - Security ...................................................}
    pnSecurity           : TPanel;
    cbSecurity           : TCheckBox;
    gbSecurityLogging    : TGroupBox;
    NoLog                : TCheckBox;
    cbSecurityLogging    : TCheckBox;
    LogFile              : TFilenameEdit;
    gbSecurityOTP        : TGroupBox;
    cbSecurityOTP        : TCheckBox;
    SearchOTP            : TCheckBox;
    DeletePass           : TCheckBox;
    {Main window - Security - SSL .............................................}
    pnSecuritySSL        : TPanel;
    cbSecuritySSL: TCheckBox;
    {Main window - Console ....................................................}
    pnConsole            : TPanel;
    cbConsole            : TCheckBox;
    gbConsoleFont        : TGroupBox;
    LFont                : TLabel;
    FontName             : TFontComboBox;
    LSize                : TLabel;
    FontSize             : TComboBox;
    LInvisible           : TLabel;
    FontExample          : TLabel;
    {Main window - Console - Window ...........................................}
    pnConsoleWindow      : TPanel;
    cbConsoleWindow      : TCheckBox;
    gbConsoleWindow      : TGroupBox;
    LRows                : TLabel;
    Rows                 : TRxSpinEdit;
    LCols                : TLabel;
    Cols                 : TRxSpinEdit;
    LWLeft               : TLabel;
    WLeft                : TRxSpinEdit;
    LWTop                : TLabel;
    WTop                 : TRxSpinEdit;
    gbWinResizeWillCause : TGroupBox;
    ChangeRowsCols       : TRadioButton;
    ChangeFontSize       : TRadioButton;
    ChangeNotAllowed     : TRadioButton;
    gbUnixLikePaste      : TGroupBox;
    UnixLikePaste_None   : TRadioButton;
    UnixLikePaste_Middle : TRadioButton;
    UnixLikePaste_Right  : TRadioButton;
    gbCursor             : TGroupBox;
    CursorInsert         : TRadioButton;
    CursorOverride       : TRadioButton;
    CursorLine           : TRadioButton;
    {Main window - Console - colors ...........................................}
    pnConsoleColors      : TPanel;
    cbColors             : TCheckBox;
    gbColors             : TGroupBox;
    black                : TCheckBox;
     blackB              : TPanel;
     blackF              : TPanel;
    red                  : TCheckBox;
     redB                : TPanel;
     redF                : TPanel;
    green                : TCheckBox;
     greenB              : TPanel;
     greenF              : TPanel;
    yellow               : TCheckBox;
     yellowB             : TPanel;
     yellowF             : TPanel;
    blue                 : TCheckBox;
     blueB               : TPanel;
     blueF               : TPanel;
    magenta              : TCheckBox;
     magentaB            : TPanel;
     magentaF            : TPanel;
    cyan                 : TCheckBox;
     cyanB               : TPanel;
     cyanF               : TPanel;
    white                : TCheckBox;
     whiteB              : TPanel;
     whiteF              : TPanel;
    gbSubstitutionColors : TGroupBox;
    normal               : TCheckBox;
     normalB             : TPanel;
     normalF             : TPanel;
    bold                 : TCheckBox;
     boldB               : TPanel;
     boldF               : TPanel;
    underline            : TCheckBox;
     underlineB          : TPanel;
     underlineF          : TPanel;
    blink                : TCheckBox;
     blinkB              : TPanel;
     blinkF              : TPanel;
    reverse              : TCheckBox;
    nonvisible           : TCheckBox;
     nonvisibleB         : TPanel;
    pmColors             : TPopupMenu;
    mpColors_Background  : TMenuItem;
    mpColors_ActiveCaption: TMenuItem;
    mpColors_InactiveCaption: TMenuItem;
    mpColors_Menu        : TMenuItem;
    mpColors_Window      : TMenuItem;
    mpColors_WindowFrame : TMenuItem;
    mpColors_MenuText    : TMenuItem;
    mpColors_WindowText  : TMenuItem;
    mpColors_CaptionText : TMenuItem;
    mpColors_ActiveBorder: TMenuItem;
    mpColors_InactiveBorder: TMenuItem;
    mpColors_AppWorkSpace: TMenuItem;
    mpColors_Highlight   : TMenuItem;
    mpColors_HighlightText: TMenuItem;
    mpColors_BtnFace     : TMenuItem;
    mpColors_BtnShadow   : TMenuItem;
    mpColors_GrayText    : TMenuItem;
    mpColors_BtnText     : TMenuItem;
    mpColors_InactiveCaptionText: TMenuItem;
    mpColors_BtnHighlight: TMenuItem;
    ColorDialog          : TColorDialog;
    {Main window - UserAcounts ................................................}
    pnUserAcounts        : TPanel;
    cbUserAcounts        : TCheckBox;
    {FTP server ...............................................................}
    cbFTP                : TCheckBox;
    pnFTP                : TPanel;
    cbDifferntIP         : TCheckBox;
    gbDifferentIP        : TGroupBox;
    rbStill              : TRadioButton;
    rbAsk                : TRadioButton;
    rbNever              : TRadioButton;
    cbFileSystem         : TCheckBox;
    gbFileSystem         : TGroupBox;
    HomeDir              : TEdit;
    LHomeDir             : TLabel;
    cbAdvancedFTP_RO     : TCheckBox;
    AdvancedFTP_RO       : TEdit;
    cbAdvancedFTP_RW     : TCheckBox;
    AdvancedFTP_RW       : TEdit;
    cbDNSnames           : TCheckBox;
    {Printer profiles .........................................................}
    cbPrinters           : TCheckBox;
    pnPrinters           : TPanel;
    gbPrinters           : TGroupBox;
    lbPrinters           : TListBox;
    btnPrinterNew        : TButton;
    btnPrinterDelete     : TButton;
    bvPrinter            : TBevel;
    LProfileName         : TLabel;
    ProfileName          : TEdit;
    LAccessBy            : TLabel;
     rbDirrect           : TRadioButton;
     cbPrinter           : TCheckBox;
     rbWindows           : TRadioButton;
    LPrinterName         : TLabel;
    PrinterName          : TComboBox;
    cbPrinterCharset     : TCheckBox;
    PrinterHostCharset   : TComboBox;
    PrinterLocalCharset  : TComboBox;
    PrinterLineArt       : TComboBox;
    cbprinter_LF2CRLF: TCheckBox;

    {Buttons}
    pnButtons            : TPanel;
    btnOk                : TButton;
    btnCancel            : TButton;
    cbLocalEcho: TCheckBox;
    LocalEchoF: TPanel;
    LocalEchoB: TPanel;
    cbDoLocalEcho: TCheckBox;
    cbLineMode: TCheckBox;
    cbCR2CRLF: TCheckBox;
    LPrinterLineArt: TLabel;
    Notebook1: TNotebook;
    LPrinterFont: TLabel;
    PrinterFont: TFontComboBox;
    PrinterFontSize: TComboBox;
    LPrinterFontSize: TLabel;
    LPrinterInitDone: TLabel;
    LPrinterIDStart: TLabel;
    LPrinterIDStop: TLabel;
    PrinterIDStart: TFilenameEdit;
    PrinterIDStop: TFilenameEdit;
    pnEnvironment: TPanel;
    cbEnvironment: TCheckBox;
    gbEnv: TGroupBox;
    btnEnvNew: TButton;
    pnEnv: TPanel;
    pnEnvGrid: TPanel;
    EnvGrid: TStringGrid;
    btnEnvDel: TButton;
    CursorF: TPanel;
    cbDebug: TCheckBox;
    cbDebugHEX: TCheckBox;
    cbprinter_CR2CRLF: TCheckBox;
    FontBold: TCheckBox;
    gbAreaSelect: TGroupBox;
    AreaSelect_Color: TPanel;
    AreaSelect_SolidFill: TCheckBox;
    AreaSelect_ColorL: TLabel;
    DontShowPrintSetupBeforePrinting: TCheckBox;
    GroupBox1: TGroupBox;
    cbEnableSSL: TCheckBox;
    cbRequireSSL: TCheckBox;
    cbDirectSSL: TCheckBox;
    SSLVersion: TComboBox;
    LSSLVersion: TLabel;
    btnBrowse: TButton;

    procedure FontChange(Sender: TObject);
    procedure OptionTreeClick(Sender: TObject);
    procedure CharSetEncClick(Sender: TObject);
    procedure LSemigraphicsCPClick(Sender: TObject);
    procedure KeybCharSetCheckBoxClick(Sender: TObject);
    procedure normalBMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure mpColorsClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure cbAdvancedFTP_RWClick(Sender: TObject);
    procedure cbAdvancedFTP_ROClick(Sender: TObject);
    procedure rbAccessByClick(Sender: TObject);
    procedure btnPrinterNewClick(Sender: TObject);
    procedure ProfileNameChange(Sender: TObject);
    procedure lbPrintersClick(Sender: TObject);
    procedure btnPrinterDeleteClick(Sender: TObject);
    procedure PrinterFontChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnEnvNewClick(Sender: TObject);
    procedure btnEnvDelClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure EnvGridKeyPress(Sender: TObject; var Key: Char);
    procedure cbEnableSSLClick(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
  private
    onConnection,    onCharset,
    onEnvironment,
    onSecurity,      onSecuritySSL,
    onConsole,       onConsoleWindow,
    onConsoleColors, onUserAcounts,
    onFTP,           onPrinters
                                 : LongInt;
    FSuperUserMode               : Boolean;
    SelectedPanel                : TPanel;
    FShowOnlyPrinter             : Boolean;
    FShowOnlyFTP                 : Boolean;
    FEnvList                     : TStringList;
    PortList                     : TStringList;
    { Private declarations }
    function RData:TdConnectionParameters;
    procedure WData(D:TdConnectionParameters);
    procedure WSuperUserMode(SuperUserMode:Boolean);
    Procedure SelectPage(CP:TCFGPages);
    Procedure PrinterDisEnab(B:Boolean);
    Procedure PrinterSelect(Const aProfileName:String);
    Procedure PrinterWData(Prn:PdPrinter);
    Procedure PrinterRData(Prn:PdPrinter);
    Procedure PrinterCData;
    Procedure PrinterSetPrinterNames(Direct: Boolean; OldSelection: String);
    Procedure CheckEnvGrid;
    procedure CheckSSLBoxes;
    procedure EnumPorts;
  public
    { Public declarations }
    constructor Create(aOwner:TComponent); override;
    destructor Destroy; override;
    Function ReadMSG:Boolean; override;
    procedure CreateOptionTree;
    procedure DestroyOptionTree;
    procedure Check;
    property Data           : TdConnectionParameters Read RData            Write WData;
    property SuperUserMode  : Boolean                Read FSuperUserMode   Write WSuperUserMode;
    Property ShowOnlyFTP    : Boolean                read FShowOnlyFTP     write FShowOnlyFTP;
    Property ShowOnlyPrinter: Boolean                read FShowOnlyPrinter write FShowOnlyPrinter;
  end;

var
  fConnectionParameters: TfConnectionParameters;

implementation
Uses
  OneLine, C3216, kUnits, SafeMem, WinSpool, Windows,
  NetworkPrinterInDirectModeSelect;

Type
  PLOGFONT    = ^TLOGFONT;
  PTEXTMETRIC = ^TTEXTMETRIC;
Const
  ctSubstTableExists : String = 'SubstTableExists';
  ctSubstTableExists2: String = 'SubstTableExists2';
  ctSubstDelete      : String = 'SubstDetete';
  ctSubstTable       : String = 'SubstTable';
  ctNewSubsName      : String = 'NewSubstName';
  ctInvalidPatchName : String = 'InvalidPatchName';

{$R *.DFM}

procedure EnumFontSizes(FontSizes:TStrings;FontName:PChar; Bold: Boolean);
Var
  FontSizeList : TSortedList;
  FD           : PFontData;
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'EnumFontSizes', 'Begin');{$ENDIF}
  FontSizeList:=TSortedList.Create;
  FontSizes.Clear;

  FontData_Enum(FontSizeList, FontName, Bold);

  While FontSizeList.Count>0 Do Begin
    FD := FontSizeList.Items[0];
    FontSizeList.Delete(0);
    FontSizes.Add(IntToStr(FD^.Size));
    SafeFreeMem(FD, SizeOf(FD^));
  End;
  FontSizeList.Destroy;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'EnumFontSizes', 'End');{$ENDIF}
end;

Function xInt(Const S:String):String;
Begin
  If S='' Then Result := '0' Else Result := S;
End;

procedure TfConnectionParameters.WSuperUserMode(SuperUserMode:Boolean);
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.WSuperUserMode', 'Begin');{$ENDIF}
  FSuperUserMode := SuperUserMode;
  DestroyOptionTree;
  CreateOptionTree;
  Check;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.WSuperUserMode', 'End');{$ENDIF}
End;

procedure TfConnectionParameters.FontChange(Sender: TObject);
Var
  OldSize : String;
  S       : ShortString;
  I       : Integer;
begin
  If not Visible Then Exit;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.FontChange', 'Begin');{$ENDIF}
  OldSize := xInt(FontSize.Items[FontSize.ItemIndex]);

  S := FontName.FontName+#0;
  EnumFontSizes(FontSize.Items, @S[1], FontBold.Checked);

  FontExample.Font.Name    := FontName.FontName;
  FontSize.ItemIndex       := StringsFindNearest(FontSize.Items, OldSize, True);
  I                        := ValidFontHeight(FontName.FontName,
                              StrToInt(xInt(FontSize.Items[FontSize.ItemIndex])));
  If FontBold.Checked Then FontExample.Font.Style:=[fsBold] Else FontExample.Font.Style:=[]; 
  If I>0 Then FontExample.Font.Height:=I Else FontExample.Font.Size  :=-I;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.FontChange', 'End');{$ENDIF}
end;

procedure TfConnectionParameters.Check;
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.Check', 'Begin');{$ENDIF}
  CharSetEnc.Checked:=CharSetEnc.Checked and (Assigned(CFG^.CodePageNames));
  CharSetEnc.Enabled:=Assigned(CFG^.CodePageNames);

  gbSecurityLogging.Visible   := cbSecurityLogging.Checked or FSuperUserMode;
  gbSecurityOTP.Visible       := cbSecurityOTP.Checked or FSuperUserMode;
    if not gbSecurityLogging.Visible Then
     gbSecurityOTP.Top:=gbSecurityLogging.Top
    Else
     gbSecurityOTP.Top:=gbSecurityLogging.Top+gbSecurityLogging.Height+8;
  HostCP.Enabled              := CharSetEnc.Checked;
  LocalCP.Enabled             := CharSetEnc.Checked;
  LHostCP.Enabled             := CharSetEnc.Checked;
  LLocalCP.Enabled            := CharSetEnc.Checked;
  LSemigraphicsCP.Enabled     := CharSetEnc.Checked;
  SemigraphicsCP.Enabled      := CharSetEnc.Checked;
  KeybCharSetCheckBox.Enabled := CharSetEnc.Checked;
  KeybCharSet.Enabled         := CharSetEnc.Checked and KeybCharSetCheckBox.Checked;
  gbDifferentIP.Enabled       := cbDifferntIP.Checked or FSuperUserMode;
    rbStill.Enabled           := gbDifferentIP.Enabled;
    rbAsk.Enabled             := gbDifferentIP.Enabled;
    rbNever.Enabled           := gbDifferentIP.Enabled;
  gbFileSystem.Enabled        := cbFileSystem.Checked or FSuperUserMode;
    LHomeDir.Enabled          := gbFileSystem.Enabled;
    HomeDir.Enabled           := gbFileSystem.Enabled;
    cbAdvancedFTP_RO.Enabled  := gbFileSystem.Enabled;
    AdvancedFTP_RO.Enabled    := cbAdvancedFTP_RO.Checked and gbFileSystem.Enabled;
    cbAdvancedFTP_RW.Enabled  := gbFileSystem.Enabled;
    AdvancedFTP_RW.Enabled    := cbAdvancedFTP_RW.Checked and gbFileSystem.Enabled;
  If cbAdvancedFTP_RO.Checked Then AdvancedFTP_RO.Color:=clWindow Else AdvancedFTP_RO.Color:=clbtnFace;
  If cbAdvancedFTP_RW.Checked Then AdvancedFTP_RW.Color:=clWindow Else AdvancedFTP_RW.Color:=clbtnFace;

  LHost              .Enabled := FSuperUserMode or cbConnection.Checked;
  Host               .Enabled := FSuperUserMode or cbConnection.Checked;
  LPort              .Enabled := FSuperUserMode or cbConnection.Checked;
  Port               .Enabled := FSuperUserMode or cbConnection.Checked;
  LCaption           .Enabled := FSuperUserMode or cbConnection.Checked;
  ConnectionCaption  .Enabled := FSuperUserMode or cbConnection.Checked;
  LTerminalType      .Enabled := FSuperUserMode or cbConnection.Checked;
  TerminalType       .Enabled := FSuperUserMode or cbConnection.Checked;
  cbEnableSSL        .Enabled := FSuperUserMode or cbConnection.Checked;
  cbRequireSSL       .Enabled := FSuperUserMode or cbConnection.Checked;
  cbDirectSSL        .Enabled := FSuperUserMode or cbConnection.Checked;
  CheckSSLBoxes;
  cbDoLocalEcho      .Enabled := FSuperUserMode or cbConnection.Checked;
  cbLineMode         .Enabled := FSuperUserMode or cbConnection.Checked;
  cbDebug            .Enabled := FSuperUserMode or cbConnection.Checked;
  cbDebugHEX         .Enabled := FSuperUserMode or cbConnection.Checked;
  cbCR2CRLF          .Enabled := FSuperUserMode or cbConnection.Checked;

  cbConnection     .Visible   := FSuperUserMode;
  cbCharSet        .Visible   := FSuperUserMode;
  cbEnvironment    .Visible   := FSuperUserMode;
  cbSecurity       .Visible   := FSuperUserMode;
  cbSecurityLogging.Visible   := FSuperUserMode;
  cbSecurityOTP    .Visible   := FSuperUserMode;
  cbSecuritySSL    .Visible   := FSuperUserMode;
  cbConsole        .Visible   := FSuperUserMode;
  cbConsoleWindow  .Visible   := FSuperUserMode;
  cbColors         .Visible   := FSuperUserMode;
  cbUserAcounts    .Visible   := FSuperUserMode;
  cbFTP            .Visible   := FSuperUserMode;
  cbDifferntIP     .Visible   := FSuperUserMode;
  cbFileSystem     .Visible   := FSuperUserMode;
  cbPrinter        .Visible   := FSuperUserMode;

  If CodePageGetNo(HostCP.     Items[HostCP     .ItemIndex])<0 Then HostCP.ItemIndex:=0;
  If CodePageGetNo(LocalCP.    Items[LocalCP    .ItemIndex])<0 Then LocalCP.ItemIndex:=0;
  If CodePageGetNo(KeybCharSet.Items[KeybCharSet.ItemIndex])<0 Then KeybCharSet.ItemIndex:=0;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.Check', 'End');{$ENDIF}
End;

procedure TfConnectionParameters.CreateOptionTree;
Const
  onTopLevel = 0;
Function MakeNode(Position:LongInt;Const Caption:String):Longint;
Begin
  If (Position<>-1)Then
   Begin
     Result := OptionTree.AddChild(Position,Caption);
     OptionTree.Items[Result].Expanded:=True;
   End
  Else
   Result := -1;
End;

begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.CreateOptionTree', 'Begin');{$ENDIF}

  onConnection   := -1;
  onCharset      := -1;
  onEnvironment  := -1;
  onSecurity     := -1;
  onSecuritySSL  := -1;
  onConsole      := -1;
  onConsoleColors:= -1;
  onUserAcounts  := -1;
  onFTP          := -1;
  onPrinters     := -1;

  If (FSuperUserMode or {cbConnection.Checked}True)and(not FShowOnlyPrinter and not ShowOnlyFTP) Then Begin
    onConnection := MakeNode(onTopLevel,pnConnection.Caption);
    If FSuperUserMode or cbCharSet.Checked Then Begin
      onCharset        :=MakeNode(onConnection,pnCharset.Caption);
    End;
    If FSuperUserMode or cbEnvironment.Checked Then Begin
      onEnvironment    :=MakeNode(onConnection,pnEnvironment.Caption);
    End;
    If FSuperUserMode or cbSecurity.Checked Then Begin
      onSecurity       :=MakeNode(onConnection,pnSecurity.Caption);
      If FSuperUserMode or cbSecuritySSL.Checked Then Begin
        onSecuritySSL  :=MakeNode(onSecurity,pnSecuritySSL.Caption);
      End;
    End;
    If FSuperUserMode or cbConsole.Checked Then Begin
      onConsole        :=MakeNode(onConnection,pnConsole.Caption);
      If FSuperUserMode or cbConsoleWindow.Checked Then Begin
        onConsoleWindow:=MakeNode(onConsole ,pnConsoleWindow.Caption);
      End;
      If FSuperUserMode or cbColors.Checked Then Begin
        onConsoleColors:=MakeNode(onConsole ,pnConsoleColors.Caption);
      End;
    End;
    If FSuperUserMode or cbUserAcounts.Checked Then Begin
      onUserAcounts  :=MakeNode(onConnection,pnUserAcounts.Caption);
    End;
  End;
  If(FSuperUserMode or cbFTP.Checked)and(not ShowOnlyPrinter)Then
  Begin
    onFTP := MakeNode(onTopLevel,pnFTP.Caption);
    If ShowOnlyFTP Then SelectPage(cpFTP);
  End;
  If(FSuperUserMode or True)and(not ShowOnlyFTP)Then
  Begin
    onPrinters := MakeNode(onTopLevel,pnPrinters.Caption);
    If ShowOnlyPrinter Then SelectPage(cpPrinters);
  End;

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.CreateOptionTree', 'End');{$ENDIF}
End;

procedure TfConnectionParameters.OptionTreeClick(Sender: TObject);
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.OptionTreeClick', 'Begin');{$ENDIF}
  If OptionTree.SelectedItem=onConnection    Then Notebook.ActivePage :='Connection'   ;
  If OptionTree.SelectedItem=onCharset       Then Notebook.ActivePage :='Charset'      ;
  If OptionTree.SelectedItem=onEnvironment   Then Notebook.ActivePage :='Environment'  ;
  If OptionTree.SelectedItem=onSecurity      Then Notebook.ActivePage :='Security'     ;
  If OptionTree.SelectedItem=onSecuritySSL   Then Notebook.ActivePage :='SecuritySSL'  ;
  If OptionTree.SelectedItem=onConsole       Then Notebook.ActivePage :='Console'      ;
  If OptionTree.SelectedItem=onConsoleColors Then Notebook.ActivePage :='ConsoleColors';
  If OptionTree.SelectedItem=onConsoleWindow Then Notebook.ActivePage :='ConsoleWindow';
  If OptionTree.SelectedItem=onUserAcounts   Then Notebook.ActivePage :='UserAcounts'  ;
  If OptionTree.SelectedItem=onFTP           Then Notebook.ActivePage :='FTP'          ;
  If OptionTree.SelectedItem=onPrinters      Then Notebook.ActivePage :='Printers'     ;
  OptionTree.HelpContext :=Notebook.HelpContext;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.OptionTreeClick', 'End');{$ENDIF}
end;

Function TfConnectionParameters.RData:TdConnectionParameters;
Procedure REnvironment;
Var
  I  : Integer;
Begin
  Result.Environment.List:=FEnvList;
  Result.Environment.List.Clear;
  For I:=0 To EnvGrid.RowCount-2 Do
    If Trim(EnvGrid.Cells[0,I+1])<>'' Then Result.Environment.List.Add(EnvGrid.Cells[0,I+1]);
End;
Var
  P :PdPrinter;
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.RData', 'Begin');{$ENDIF}
  Result.Connection._Enabled                             := cbConnection.Checked;
  Result.Connection.Host                                 := Host.Text;
  Result.Connection.Port                                 := Port.Text;
  Result.Connection.Caption                              := ConnectionCaption.Text;
  Result.Connection.TerminalType                         := TerminalType.Items[TerminalType.ItemIndex];
  Result.Connection.LocalEcho                            := cbDoLocalEcho.Checked;
  Result.Connection.LineMode                             := cbLineMode.Checked;
  Result.Connection.CR2CRLF                              := cbCR2CRLF.Checked;
  Result.Connection.DebugLevel                           := Byte(cbDebug.Checked)*1+
                                                            Byte(cbDebugHEX.Checked)*2;
  Result.Connection.SSL                                  := Byte(cbEnableSSL.Checked)*1+
                                                            Byte(cbRequireSSL.Checked)*2+
                                                            Byte(cbDirectSSL.Checked)*4;
  Result.Connection.SSLVersion                           := SSLVersion.Items[SSLVersion.ItemIndex];
  
  Result.CharSet._Enabled                                := cbCharSet.Checked;
  Result.CharSet.CharSetEnc                              := CharSetEnc.Checked;
  Result.CharSet.HostCP                                                                   := HostCP.Items[HostCP.ItemIndex];
  Result.CharSet.LocalCP                                 := LocalCP.Items[LocalCP.ItemIndex];
  Result.CharSet.EnabledLD                               := True;
  Result.CharSet.SemigraphicsCP                          := SemigraphicsCP.Items[SemigraphicsCP.ItemIndex];
  Result.CharSet.KeybCharSetCheckBox                     := KeybCharSetCheckBox.Checked;
  Result.CharSet.KeybCharSet                             := KeybCharSet.Items[KeybCharSet.ItemIndex];

  Result.Environment._Enabled                            := cbEnvironment.Checked;
    REnvironment;

  Result.Security._Enabled                               := cbSecurity.Checked;
  Result.Security.Logging._Enabled                       := cbSecurityLogging.Checked;
  Result.Security.Logging.NoLog                          := NoLog.Checked;
  Result.Security.Logging.LogFile                        := LogFile.Text;
  Result.Security.OTP._Enabled                           := cbSecurityOTP.Checked;
  Result.Security.OTP.SearchOTP                          := SearchOTP.Checked;
  Result.Security.OTP.DeletePass                         := DeletePass.Checked;
  Result.Security.SSL._Enabled                           := cbSecuritySSL.Checked;
  Result.Console._Enabled                                := cbConsole.Checked;
  Result.Console.Font._Enabled                           := True;
  Result.Console.Font.Name                               := FontName.FontName;
  Result.Console.Font.Size                               := StrToInt(xInt(FontSize.Items[FontSize.ItemIndex]));
  Result.Console.Font.Bold                               := FontBold.Checked;
  Result.Console.Window._Enabled                         := cbConsoleWindow.Checked;
  Result.Console.Window.Cols                             := Round(Cols.Value);
  Result.Console.Window.Rows                             := Round(Rows.Value);
  Result.Console.Window.Top                              := Round(WTop.Value);
  Result.Console.Window.Left                             := Round(WLeft.Value);
  If ChangeRowsCols.Checked   Then Result.Console.Window.WinResizeWillCause := rmDimensionChange;
  If ChangeFontSize.Checked   Then Result.Console.Window.WinResizeWillCause := rmFontSizeChange;
  If ChangeNotAllowed.Checked Then Result.Console.Window.WinResizeWillCause := rmNoChange;
  Result.Console.Window.UnixLikePaste      := Byte(UnixLikePaste_None.Checked)*1+
                                              Byte(UnixLikePaste_Middle.Checked)*2+
                                              Byte(UnixLikePaste_Right.Checked)*3;
  Result.Console.Window.CursorMode := Byte(CursorOverride .Checked)*0+
                                      Byte(CursorInsert   .Checked)*1+
                                      Byte(CursorLine     .Checked)*2;
  Result.Console.Window.FillInArea                       := AreaSelect_SolidFill.Checked;
  Result.Console.Window.AreaColor                        := AreaSelect_Color.Color;
  Result.Console.Colors._Enabled       := cbColors.Checked;
  Result.Console.Colors.black          := black.Checked;
  Result.Console.Colors.blackB         := blackB.Color;
  Result.Console.Colors.blackF         := blackF.Color;
  Result.Console.Colors.red            := red.Checked;
  Result.Console.Colors.redB           := redB.Color;
  Result.Console.Colors.redF           := redF.Color;
  Result.Console.Colors.green          := green.Checked;
  Result.Console.Colors.greenB         := greenB.Color;
  Result.Console.Colors.greenF         := greenF.Color;
  Result.Console.Colors.yellow         := yellow.Checked;
  Result.Console.Colors.yellowB        := yellowB.Color;
  Result.Console.Colors.yellowF        := yellowF.Color;
  Result.Console.Colors.blue           := blue.Checked;
  Result.Console.Colors.blueB          := blueB.Color;
  Result.Console.Colors.blueF          := blueF.Color;
  Result.Console.Colors.magenta        := magenta.Checked;
  Result.Console.Colors.magentaB       := magentaB.Color;
  Result.Console.Colors.magentaF       := magentaF.Color;
  Result.Console.Colors.cyan           := cyan.Checked;
  Result.Console.Colors.cyanB          := cyanB.Color;
  Result.Console.Colors.cyanF          := cyanF.Color;
  Result.Console.Colors.white          := white.Checked;
  Result.Console.Colors.whiteB         := whiteB.Color;
  Result.Console.Colors.whiteF         := whiteF.Color;
  Result.Console.Colors.normal         := normal.Checked;
  Result.Console.Colors.normalB        := normalB.Color;
  Result.Console.Colors.normalF        := normalF.Color;
  Result.Console.Colors.bold           := bold.Checked;
  Result.Console.Colors.boldB          := boldB.Color;
  Result.Console.Colors.boldF          := boldF.Color;
  Result.Console.Colors.underline      := underline.Checked;
  Result.Console.Colors.underlineB     := underlineB.Color;
  Result.Console.Colors.underlineF     := underlineF.Color;
  Result.Console.Colors.blink          := blink.Checked;
  Result.Console.Colors.blinkB         := blinkB.Color;
  Result.Console.Colors.blinkF         := blinkF.Color;
  Result.Console.Colors.reverse        := reverse.Checked;
  Result.Console.Colors.nonvisible     := nonvisible.Checked;
  Result.Console.Colors.nonvisibleB    := nonvisibleB.Color;
  Result.Console.Colors.LocalEcho      := cbLocalEcho.Checked;
  Result.Console.Colors.LocalEchoB     := LocalEchoB.Color;
  Result.Console.Colors.LocalEchoF     := LocalEchoF.Color;
  Result.Console.Colors.Cursor         := CursorF.Color;
  Result.UserAcounts._Enabled          := cbUserAcounts.Checked;

  CFG^.FTP._Enabled                    := cbFTP.Checked;
  CFG^.FTP.DifferentIP._Enabled        := cbDifferntIP.Checked;
  If rbStill.Checked Then CFG^.FTP.DifferentIP.Mode:=0;
  If rbAsk  .Checked Then CFG^.FTP.DifferentIP.Mode:=1;
  If rbNever.Checked Then CFG^.FTP.DifferentIP.Mode:=2;
  CFG^.FTP.DNSResolv                   := cbDNSnames.Checked;
  CFG^.FTP.FileSystem._Enabled         := cbFileSystem.Checked;
  CFG^.FTP.FileSystem.HomeDir          := HomeDir.Text;
  CFG^.FTP.FileSystem.EnabRO           := cbAdvancedFTP_RO.Checked;
  CFG^.FTP.FileSystem.RODirs           := AdvancedFTP_RO.Text;
  CFG^.FTP.FileSystem.EnabRW           := cbAdvancedFTP_RW.Checked;
  CFG^.FTP.FileSystem.RWDirs           := AdvancedFTP_RW.Text;
  CFG^.Printer                         := ProfileName.Text;

  P := PrinterGetP(ProfileName.Text);
  If P<>nil Then Begin
    PrinterRData(P);
    PrinterSelect(lbPrinters.Items[lbPrinters.ItemIndex]);
  End;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.RData', 'End');{$ENDIF}
End;

Procedure TfConnectionParameters.WData(D:TdConnectionParameters);
Procedure WEnvironment;
Var
  I  : Integer;
Begin
  FEnvList := D.Environment.List;
  EnvGrid.RowCount := Max(D.Environment.List.Count+1, 2);
  For I:=0 To D.Environment.List.Count-1 Do
    EnvGrid.Cells[0,I+1]:=D.Environment.List.Strings[I];
End;

Var
  I  : Integer;
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.WData', 'Begin');{$ENDIF}
  If CFG^.CodePageNames=nil Then Begin
    HostCP.Items.Clear;
    LocalCP.Items.Clear;
    SemigraphicsCP.Items.Clear;
    KeybCharSet.Items.Clear;
    PrinterHostCharset.Items.Clear;
    PrinterLocalCharset.Items.Clear;
    PrinterLineArt.Items.Clear;
  End Else Begin
    HostCP.Items.Assign(CFG^.CodePageNames);
    LocalCP.Items.Assign(CFG^.CodePageNames);
    SemigraphicsCP.Items.Assign(CFG^.CodePageNames);
    KeybCharSet.Items.Assign(CFG^.CodePageNames);
    PrinterHostCharset.Items.Assign(CFG^.CodePageNames);
    PrinterLocalCharset.Items.Assign(CFG^.CodePageNames);
    PrinterLineArt.Items.Assign(CFG^.CodePageNames);
  End;
  PrinterList(lbPrinters.Items);
  PrinterName.Items.Assign(Printer.Printers);
  If Printer.Printers.Count=1 Then Begin
    If Printer.Printers.Strings[0]=' on ' Then
      PrinterName.Items.Clear;
  End;
  PrinterDisEnab(False);
  TerminalType.Items.Clear;
  For I:=0 To CFG^.Terminals.Count-1 Do Begin
    TerminalType.Items.Add(PTerminal(CFG^.Terminals.Items[I])^.Name);
  End;

  cbConnection.Checked             := D.Connection._Enabled;
    Host.Text                      := D.Connection.Host;
    Port.Text                      := D.Connection.Port;
    ConnectionCaption.Text         := D.Connection.Caption;
    TerminalType.ItemIndex         := StringsFindNearest(TerminalType.Items, D.Connection.TerminalType, False);
    cbDoLocalEcho.Checked          := D.Connection.LocalEcho;
    cbLineMode.Checked             := D.Connection.LineMode;
    cbCR2CRLF.Checked              := D.Connection.CR2CRLF;
    cbDebug.Checked                := D.Connection.DebugLevel and 1 = 1;
    cbDebugHEX.Checked             := D.Connection.DebugLevel and 2 = 2;
    cbEnableSSL.Checked            := D.Connection.SSL and 1 = 1;
    cbRequireSSL.Checked           := D.Connection.SSL and 2 = 2;
    cbDirectSSL.Checked            := D.Connection.SSL and 4 = 4;
    SSLVersion.ItemIndex           := StringsFindNearest(SSLVersion.Items, D.Connection.SSLVersion, False);

  cbCharSet.Checked                := D.CharSet._Enabled;
    CharSetEnc.Checked             := D.CharSet.CharSetEnc;
    HostCP.ItemIndex               := CodePageGetNo(D.CharSet.HostCP);
    LocalCP.ItemIndex              := CodePageGetNo(D.CharSet.LocalCP);
    SemigraphicsCP.ItemIndex       := StringsFindNearest(SemigraphicsCP.Items,D.CharSet.SemigraphicsCP, False);
    KeybCharSetCheckBox.Checked    := D.CharSet.KeybCharSetCheckBox;
    KeybCharSet.ItemIndex          := CodePageGetNo(D.CharSet.KeybCharSet);

  cbEnvironment.Checked            := D.Environment._Enabled;
    WEnvironment;
    CheckEnvGrid;

  cbSecurity.Checked               := D.Security._Enabled;
    cbSecurityLogging.Checked      := D.Security.Logging._Enabled;
      NoLog.Checked                := D.Security.Logging.NoLog;
      LogFile.Text                 := D.Security.Logging.LogFile;
    cbSecurityOTP.Checked          := D.Security.OTP._Enabled;
      SearchOTP.Checked            := D.Security.OTP.SearchOTP;
      DeletePass.Checked           := D.Security.OTP.DeletePass;
    cbSecuritySSL.Checked          := D.Security.SSL._Enabled;
  cbConsole.Checked                := D.Console._Enabled;
    FontName.FontName              := D.Console.Font.Name; FontChange(self);
    FontSize.ItemIndex             := StringsFindNearest(FontSize.Items, IntToStr(D.Console.Font.Size), True);
    FontBold.Checked               := D.Console.Font.Bold;
                                      FontChange(self);
    cbConsoleWindow.Checked        := D.Console.Window._Enabled;
      Cols.Value                   := D.Console.Window.Cols;
      Rows.Value                   := D.Console.Window.Rows;
      WTop.Value                   := D.Console.Window.Top;
      WLeft.Value                  := D.Console.Window.Left;
      ChangeRowsCols  .Checked     := D.Console.Window.WinResizeWillCause=rmDimensionChange;
      ChangeFontSize  .Checked     := D.Console.Window.WinResizeWillCause=rmFontSizeChange;
      ChangeNotAllowed.Checked     := D.Console.Window.WinResizeWillCause=rmNoChange;
      UnixLikePaste_None.Checked   := D.Console.Window.UnixLikePaste=1;
      UnixLikePaste_Middle.Checked := D.Console.Window.UnixLikePaste=2;
      UnixLikePaste_Right.Checked  := D.Console.Window.UnixLikePaste=3;
      CursorOverride .Checked      := D.Console.Window.CursorMode=0;
      CursorInsert   .Checked      := D.Console.Window.CursorMode=1;
      CursorLine     .Checked      := D.Console.Window.CursorMode=2;
      AreaSelect_SolidFill.Checked := D.Console.Window.FillInArea;
      AreaSelect_Color.Color       := D.Console.Window.AreaColor;

    cbColors.Checked               := D.Console.Colors._Enabled;
      black.Checked                := D.Console.Colors.black;
      blackB.Color                 := D.Console.Colors.blackB;
      blackF.Color                 := D.Console.Colors.blackF;
      red.Checked                  := D.Console.Colors.red;
      redB.Color                   := D.Console.Colors.redB;
      redF.Color                   := D.Console.Colors.redF;
      green.Checked                := D.Console.Colors.green;
      greenB.Color                 := D.Console.Colors.greenB;
      greenF.Color                 := D.Console.Colors.greenF;
      yellow.Checked               := D.Console.Colors.yellow;
      yellowB.Color                := D.Console.Colors.yellowB;
      yellowF.Color                := D.Console.Colors.yellowF;
      blue.Checked                 := D.Console.Colors.blue;
      blueB.Color                  := D.Console.Colors.blueB;
      blueF.Color                  := D.Console.Colors.blueF;
      magenta.Checked              := D.Console.Colors.magenta;
      magentaB.Color               := D.Console.Colors.magentaB;
      magentaF.Color               := D.Console.Colors.magentaF;
      cyan.Checked                 := D.Console.Colors.cyan;
      cyanB.Color                  := D.Console.Colors.cyanB;
      cyanF.Color                  := D.Console.Colors.cyanF;
      white.Checked                := D.Console.Colors.white;
      whiteB.Color                 := D.Console.Colors.whiteB;
      whiteF.Color                 := D.Console.Colors.whiteF;
      normal.Checked               := D.Console.Colors.normal;
      normalB.Color                := D.Console.Colors.normalB;
      normalF.Color                := D.Console.Colors.normalF;
      bold.Checked                 := D.Console.Colors.bold;
      boldB.Color                  := D.Console.Colors.boldB;
      boldF.Color                  := D.Console.Colors.boldF;
      underline.Checked            := D.Console.Colors.underline;
      underlineB.Color             := D.Console.Colors.underlineB;
      underlineF.Color             := D.Console.Colors.underlineF;
      blink.Checked                := D.Console.Colors.blink;
      blinkB.Color                 := D.Console.Colors.blinkB;
      blinkF.Color                 := D.Console.Colors.blinkF;
      reverse.Checked              := D.Console.Colors.reverse;
      nonvisible.Checked           := D.Console.Colors.nonvisible;
      nonvisibleB.Color            := D.Console.Colors.nonvisibleB;
      cbLocalEcho.Checked          := D.Console.Colors.LocalEcho;
      LocalEchoB.Color             := D.Console.Colors.LocalEchoB;
      LocalEchoF.Color             := D.Console.Colors.LocalEchoF;
      CursorF.Color                := D.Console.Colors.Cursor;
  cbUserAcounts.Checked        := D.UserAcounts._Enabled;

  cbFTP.Checked                := CFG^.FTP._Enabled;
  cbDNSnames.Checked           := CFG^.FTP.DNSResolv;
  cbDifferntIP.Checked         := CFG^.FTP.DifferentIP._Enabled;
  rbStill.Checked              := CFG^.FTP.DifferentIP.Mode=0;
  rbAsk  .Checked              := CFG^.FTP.DifferentIP.Mode=1;
  rbNever.Checked              := CFG^.FTP.DifferentIP.Mode=2;
  cbFileSystem.Checked         := CFG^.FTP.FileSystem._Enabled;
  HomeDir.Text                 := CFG^.FTP.FileSystem.HomeDir;
  cbAdvancedFTP_RO.Checked     := CFG^.FTP.FileSystem.EnabRO;
  AdvancedFTP_RO.Text          := CFG^.FTP.FileSystem.RODirs;
  cbAdvancedFTP_RW.Checked     := CFG^.FTP.FileSystem.EnabRW;
  AdvancedFTP_RW.Text          := CFG^.FTP.FileSystem.RWDirs;

  PrinterSelect(CFG^.Printer);

  DestroyOptionTree;
  CreateOptionTree;
  OptionTreeClick(Self);
  Check;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.WData', 'End');{$ENDIF}
End;

Constructor TfConnectionParameters.Create(aOwner:TComponent);
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.Create', 'Begin');{$ENDIF}

  inherited Create(aOwner);
  lbPrinters.BorderStyle:=bsSingle;
  FontExample.Color := clWindow; {32bit Delhi z neznameho duvodu ignoruji
                                  hodnotu nastaveno v 16bit *.dfm}
  {$IFDEF Win32}
  FontExample.WordWrap:=True;    {Tohle je nova vlastnost}
  {$ENDIF}

  Name           := 'fConnectionParameters';
  SavePosition   := True;
  SelectedPanel  := nil;
  ReadINI;

  FShowOnlyFTP    := False;
  FShowOnlyPrinter:= False;
  FontSize.ItemIndex:=1;
  PortList        := nil;

  Check;

  OptionTreeClick(self);

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.Create', 'End');{$ENDIF}
End;

Destructor TfConnectionParameters.Destroy;
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.Destroy', 'Begin');{$ENDIF}
  WriteINI;

  inherited Destroy;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.Destroy', 'End');{$ENDIF}
end;

Function TfConnectionParameters.ReadMSG:Boolean;
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.ReadMSG', 'Begin');{$ENDIF}

  Result := Inherited ReadMSG;
  If Result Then Begin
    ctSubstTableExists         := ReadMSGString('SubstitutionTableExists');
    ctSubstTableExists2        := ReadMSGString('SubstitutionTableExists2');
    ctSubstDelete              := ReadMSGString('SubstDelete');
    ctSubstTable               := ReadMSGString('SubstitutionTable');
    ctNewSubsName              := ReadMSGString('NewSubstitutionName');
    ctInvalidPatchName         := ReadMSGString('InvalidPatchName');
    EnvGrid.Cells[0,0]         := ReadMSGString('EnvVariable');

    btnOk.Caption              := ctbtnOk;
    btnCancel.Caption          := ctbtnCancel;

    if onConnection   > 0 Then OptionTree.Items[onConnection   ].Text := pnConnection   .Caption;
    if onCharset      > 0 Then OptionTree.Items[onCharset      ].Text := pnCharset      .Caption;
    if onEnvironment  > 0 Then OptionTree.Items[onEnvironment  ].Text := pnEnvironment  .Caption;
    if onSecurity     > 0 Then OptionTree.Items[onSecurity     ].Text := pnSecurity     .Caption;
    if onSecuritySSL  > 0 Then OptionTree.Items[onSecuritySSL  ].Text := pnSecuritySSL  .Caption;
    if onConsole      > 0 Then OptionTree.Items[onConsole      ].Text := pnConsole      .Caption;
    if onConsoleColors> 0 Then OptionTree.Items[onConsoleColors].Text := pnConsoleColors.Caption;
    if onUserAcounts  > 0 Then OptionTree.Items[onUserAcounts  ].Text := pnUserAcounts  .Caption;
    if onFTP          > 0 Then OptionTree.Items[onFTP          ].Text := pnFTP          .Caption;
    if onPrinters     > 0 Then OptionTree.Items[onPrinters     ].Text := pnPrinters     .Caption;
  End;

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.ReadMSG', 'End');{$ENDIF}
End;

procedure TfConnectionParameters.CharSetEncClick(Sender: TObject);
begin
  Check;
end;

procedure TfConnectionParameters.LSemigraphicsCPClick(Sender: TObject);
begin
  Check;
end;

procedure TfConnectionParameters.KeybCharSetCheckBoxClick(Sender: TObject);
begin
  Check;
end;

procedure TfConnectionParameters.normalBMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Var
  P : TPoint;
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.normalBMouseUp', 'Begin');{$ENDIF}
  If Button=mbLeft Then Begin
    ColorDialog.Color:=(Sender as TPanel).Color;
    If ColorDialog.Execute Then (Sender as TPanel).Color:=ColorDialog.Color;
  end Else If Button=mbRight Then Begin
    SelectedPanel:=(Sender as TPanel);
    P:=Point(X,Y);
    P:=(Sender as TControl).ClientToScreen(P);
    pmColors.PopUp(P.X,P.Y);
  End;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.normalBMouseUp', 'End');{$ENDIF}
end;

procedure TfConnectionParameters.mpColorsClick(Sender: TObject);
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.mpColorsClick', 'Begin');{$ENDIF}
  If SelectedPanel=nil Then Exit;
  If (Sender as TMenuItem).Name='mpColors_Background'          Then Begin SelectedPanel.Color:=clBackground        ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_ActiveCaption'       Then Begin SelectedPanel.Color:=clActiveCaption     ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_InactiveCaption'     Then Begin SelectedPanel.Color:=clInactiveCaption   ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_Menu'                Then Begin SelectedPanel.Color:=clMenu              ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_Window'              Then Begin SelectedPanel.Color:=clWindow            ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_WindowFrame'         Then Begin SelectedPanel.Color:=clWindowFrame       ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_MenuText'            Then Begin SelectedPanel.Color:=clMenuText          ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_WindowText'          Then Begin SelectedPanel.Color:=clWindowText        ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_CaptionText'         Then Begin SelectedPanel.Color:=clCaptionText       ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_ActiveBorder'        Then Begin SelectedPanel.Color:=clActiveBorder      ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_InactiveBorder'      Then Begin SelectedPanel.Color:=clInactiveBorder    ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_AppWorkSpace'        Then Begin SelectedPanel.Color:=clAppWorkSpace      ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_Highlight'           Then Begin SelectedPanel.Color:=clHighlight         ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_HighlightText'       Then Begin SelectedPanel.Color:=clHighlightText     ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_BtnFace'             Then Begin SelectedPanel.Color:=clBtnFace           ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_BtnShadow'           Then Begin SelectedPanel.Color:=clBtnShadow         ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_GrayText'            Then Begin SelectedPanel.Color:=clGrayText          ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_BtnText'             Then Begin SelectedPanel.Color:=clBtnText           ; Exit End;
  If (Sender as TMenuItem).Name='mpColors_InactiveCaptionText' Then Begin SelectedPanel.Color:=clInactiveCaptionText;Exit End;
  If (Sender as TMenuItem).Name='mpColors_BtnHighlight'        Then Begin SelectedPanel.Color:=clBtnHighlight      ; Exit End;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.mpColorsClick', 'End');{$ENDIF}
end;

procedure TfConnectionParameters.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
 If Key=VK_ESCAPE Then Close;
end;

procedure TfConnectionParameters.DestroyOptionTree;
Begin
  While OptionTree.ItemCount>0 Do OptionTree.Delete(OptionTree.Items[OptionTree.SelectedItem].Index);
End;

(*procedure TfConnectionParameters.SelectFontSize(Size:Integer;LB:TComboBox);
Var
  I       : Integer;
  NewSize : Integer;
  NewDiff : Integer;
Begin
  I := LB.Items.IndexOf(intTostr(Size));
  If I=-1 Then Begin{Najit nejblizsi}
    If LB.Items.Count<=1 Then
     LB.ItemIndex := 0
    Else Begin
      NewSize := 0;
      NewDiff := 10000;
      For I:=0 To LB.Items.Count-1 Do
        If abs(NewSize-StrToInt(LB.Items[I]))<NewDiff Then Begin
          NewSize:=StrToInt(LB.Items[I]);
          NewDiff:=abs(NewSize-StrToInt(LB.Items[I]));
        End;
      LB.ItemIndex:=LB.Items.IndexOf(intTostr(NewSize));
    End;
  End Else Begin
    LB.ItemIndex := I;
  End;
End;*)

procedure TfConnectionParameters.cbAdvancedFTP_RWClick(Sender: TObject);
begin
  Check;
end;

procedure TfConnectionParameters.cbAdvancedFTP_ROClick(Sender: TObject);
begin
  Check;
end;

procedure TfConnectionParameters.rbAccessByClick(Sender: TObject);
begin
  If (Sender as TComponent).Name='rbWindows' Then Begin
    PrinterSetPrinterNames(False, '');
    Notebook1.ActivePage     := 'Windows';
    LPrinterFont    .Enabled := cbPrinter.Checked or FSuperUserMode;
    PrinterFont     .Enabled := cbPrinter.Checked or FSuperUserMode;
    LPrinterFontSize.Enabled := cbPrinter.Checked or FSuperUserMode;
    PrinterFontSize .Enabled := cbPrinter.Checked or FSuperUserMode;
    btnBrowse       .Enabled := False;
  End Else Begin
    PrinterSetPrinterNames(True, '');
    Notebook1.ActivePage     := 'Direct';
    LPrinterFont    .Enabled := False;
    PrinterFont     .Enabled := False;
    LPrinterFontSize.Enabled := False;
    PrinterFontSize .Enabled := False;
    btnBrowse       .Enabled := True;
  End;
end;

Procedure TfConnectionParameters.PrinterDisEnab(B:Boolean);
Begin
  LProfileName       .Enabled := B;
  ProfileName        .Enabled := B;
  LAccessBy          .Enabled := B;
  rbWindows          .Enabled := B;
  rbDirrect          .Enabled := B;
  LPrinterName       .Enabled := B;
  PrinterName        .Enabled := B;
  cbPrinterCharset   .Enabled := B;
  PrinterHostCharset .Enabled := B;
  PrinterLocalCharset.Enabled := B;
  LPrinterLineArt    .Enabled := B;
  PrinterLineArt     .Enabled := B;
  cbPrinter          .Enabled := B;
  cbprinter_LF2CRLF  .Enabled := B;
  cbprinter_CR2CRLF  .Enabled := B;
  btnPrinterDelete   .Enabled := B;
  LPrinterFont       .Enabled := B;
  PrinterFont        .Enabled := B;
  LPrinterFontSize   .Enabled := B;
  PrinterFontSize    .Enabled := B;
  LPrinterInitDone   .Enabled := B;
  PrinterIDStart     .Enabled := B;
  PrinterIDStop      .Enabled := B;
  LPrinterIDStart    .Enabled := B;
  LPrinterIDStop     .Enabled := B;
  btnBrowse          .Enabled := B;
End;

Procedure TfConnectionParameters.PrinterWData(Prn:PdPrinter);
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.PrinterWData', 'Begin');{$ENDIF}

  If Prn^.FontName='' Then Prn^.FontName := 'Courier New';

  lbPrinters.ItemIndex         := lbPrinters.Items.IndexOf(Prn^.ProfileName);
  cbPrinter.Checked            := Prn^._Enabled;
  ProfileName        .Text     := Prn^.ProfileName;
  cbPrinterCharset   .Checked  := Prn^.CharsetE;
  PrinterHostCharset .ItemIndex:= StringsFindNearest(PrinterHostCharset.Items,Prn^.HCharset, False);
  PrinterLocalCharset.ItemIndex:= StringsFindNearest(PrinterLocalCharset.Items,Prn^.LCharset, False);
  PrinterLineArt     .ItemIndex:= StringsFindNearest(PrinterLineArt.Items,Prn^.LineArt, False);
  If Prn^.AccessMode=0 Then
    rbWindows        .Checked  := True
  Else rbDirrect     .Checked  := True;
  PrinterSetPrinterNames(rbDirrect.Checked, Prn^.PrinterName);
  PrinterName        .ItemIndex:= StringsFindNearest(PrinterName.Items,Prn^.PrinterName, False);
  cbprinter_LF2CRLF  .Checked  := Prn^.LF2CRLF;
  cbprinter_CR2CRLF  .Checked  := Prn^.CR2CRLF;
  PrinterFont.FontName         := Prn^.FontName;
  PrinterFontSize.ItemIndex    := StringsFindNearest(PrinterFontSize.Items,IntToStr(Prn^.FontSize), True);
  PrinterDisEnab(cbPrinter.Checked or FSuperUserMode);
  PrinterIDStart.FileName      := Prn^.InitFile;
  PrinterIDStop.FileName       := Prn^.DoneFile;

  DontShowPrintSetupBeforePrinting.Checked := CFG^.DontShowPrnDBP;

  if rbWindows.Checked then rbAccessByClick(rbWindows) else rbAccessByClick(Self);

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.PrinterWData', 'End');{$ENDIF}
End;

Procedure TfConnectionParameters.PrinterRData(Prn:PdPrinter);
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.PrinterRData', 'Begin');{$ENDIF}

  Prn^._Enabled         := cbPrinter.Checked;
  Prn^.ProfileName      := ProfileName.Text;
  Prn^.PrinterName      := PrinterName.Items[PrinterName.ItemIndex];
  Prn^.CharsetE         := cbPrinterCharset.Checked;
  Prn^.HCharset         := PrinterHostCharset.Items[PrinterHostCharset.ItemIndex];
  Prn^.LCharset         := PrinterLocalCharset.Items[PrinterLocalCharset.ItemIndex];
  Prn^.LineArtE         := True;
  Prn^.LineArt          := PrinterLineArt.Items[PrinterLineArt.ItemIndex];
  If rbWindows.Checked Then Prn^.AccessMode := 0 Else Prn^.AccessMode := 1;
  Prn^.LF2CRLF          := cbprinter_LF2CRLF.Checked;
  Prn^.CR2CRLF          := cbprinter_CR2CRLF.Checked;
  Prn^.FontName         := PrinterFont.FontName;
  Prn^.FontSize         := StrToInt(xInt(PrinterFontSize.Items[PrinterFontSize.ItemIndex]));
  Prn^.InitFile         := PrinterIDStart.FileName;
  Prn^.DoneFile         := PrinterIDStop.FileName;

  CFG^.DontShowPrnDBP   := DontShowPrintSetupBeforePrinting.Checked;

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.PrinterRData', 'End');{$ENDIF}
End;

Procedure TfConnectionParameters.PrinterCData;
Begin
  lbPrinters.ItemIndex         := -1;
  cbPrinter.Checked            := True;
  ProfileName      .Text       := '';
  PrinterName      .ItemIndex  := -1;
  cbPrinterCharset .Checked    := False;
  PrinterHostCharset .ItemIndex:= -1;
  PrinterLocalCharset.ItemIndex:= -1;
  PrinterLineArt   .ItemIndex  := -1;
  rbDirrect        .Checked    := True;
  cbprinter_LF2CRLF.Checked    := True;
  cbprinter_CR2CRLF.Checked    := True;
  PrinterFont      .FontName   := 'Courier New';
  PrinterFontSize  .ItemIndex  := StringsFindNearest(PrinterFontSize.Items, '8', True);
End;

Procedure TfConnectionParameters.PrinterSelect(Const aProfileName:String);
Var
  Prn : PdPrinter;
Begin
  Prn:=PrinterGetP(aProfileName);
  If Prn=nil Then Begin
    If CFG^.PrinterProfiles.Count>0 Then Begin
      Prn:=CFG^.PrinterProfiles.Items[0];
      PrinterDisEnab(True and (cbPrinter.Checked or FSuperUserMode));
      PrinterWData(Prn);
    End Else Begin
      PrinterDisEnab(False);
      PrinterCData;
    End;
  End Else Begin
    PrinterDisEnab(True and (cbPrinter.Checked or FSuperUserMode));
    PrinterWData(Prn);
  End;
End;

procedure TfConnectionParameters.btnPrinterNewClick(Sender: TObject);
Var
  Prn : PdPrinter;
begin
  SafeGetMem(Prn,SizeOf(TdPrinter));
  PrinterDefault(Prn);
  CFG^.PrinterProfiles.Add(Prn);
  While lbPrinters.Items.IndexOf(Prn^.ProfileName)>=0 Do Prn^.ProfileName:='_'+Prn^.ProfileName;
  PrinterList(lbPrinters.Items);
  PrinterSelect(Prn^.ProfileName);
end;

procedure TfConnectionParameters.ProfileNameChange(Sender: TObject);
Var
  P :PdPrinter;
begin
  If lbPrinters.ItemIndex<0 Then Exit;
  P := PrinterGetP(lbPrinters.Items[lbPrinters.ItemIndex]);
  If P=nil Then Exit;
  P^.ProfileName:=ProfileName.Text;
  PrinterList(lbPrinters.Items);
  lbPrinters.ItemIndex       := lbPrinters.Items.IndexOf(P^.ProfileName);
end;

procedure TfConnectionParameters.lbPrintersClick(Sender: TObject);
Var
  P :PdPrinter;
begin
  P := PrinterGetP(ProfileName.Text); If P=nil Then Exit;
  PrinterRData(P);
  PrinterSelect(lbPrinters.Items[lbPrinters.ItemIndex]);
end;

procedure TfConnectionParameters.btnPrinterDeleteClick(Sender: TObject);
Var
  P :PdPrinter;
Begin
  P := PrinterGetP(ProfileName.Text); If P=nil Then Exit;
  CFG^.PrinterProfiles.Remove(P);
  PrinterList(lbPrinters.Items);
  If lbPrinters.Items.Count=0 Then
    PrinterSelect('')
  Else Begin
    P:=PrinterGetP(lbPrinters.Items[0]);
    PrinterSelect(P^.ProfileName);
  End;
End;

procedure TfConnectionParameters.PrinterFontChange(Sender: TObject);
Var
  OldSize : String;
  S       : ShortString;
begin
  OldSize := xInt(FontSize.Items[FontSize.ItemIndex]);

  S := PrinterFont.FontName+#0;
  EnumFontSizes(PrinterFontSize.Items, @S[1], False);
  PrinterFontSize.ItemIndex := StringsFindNearest(PrinterFontSize.Items,OldSize, True);
end;

Procedure TfConnectionParameters.SelectPage(CP:TCFGPages);
Begin
  Case CP of
    cpConnection     : If onConnection   <>-1 Then Notebook.ActivePage := 'Connection'   ;
    cpCharset        : If onCharset      <>-1 Then Notebook.ActivePage := 'Charset'      ;
    cpSecurity       : If onSecurity     <>-1 Then Notebook.ActivePage := 'Security'     ;
    cpSecuritySSL    : If onSecuritySSL  <>-1 Then Notebook.ActivePage := 'SecuritySSL'  ;
    cpConsole        : If onConsole      <>-1 Then Notebook.ActivePage := 'Console'      ;
    cpConsoleWindow  : If onConsoleColors<>-1 Then Notebook.ActivePage := 'ConsoleColors';
    cpConsoleColors  : If onConsoleWindow<>-1 Then Notebook.ActivePage := 'ConsoleWindow';
    cpUserAcounts    : If onUserAcounts  <>-1 Then Notebook.ActivePage := 'UserAcounts'  ;
    cpFTP            : If onFTP          <>-1 Then Notebook.ActivePage := 'FTP'          ;
    cpPrinters       : If onPrinters     <>-1 Then Notebook.ActivePage := 'Printers'     ;
    Else               Notebook.ActivePage := 'Empty';
  End;
End;

procedure TfConnectionParameters.FormResize(Sender: TObject);
begin
  CheckEnvGrid;
end;

procedure TfConnectionParameters.FormShow(Sender: TObject);
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.FormShow', 'Begin');{$ENDIF}
  FontChange(Self);
  CheckEnvGrid;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.FormShow', 'End');{$ENDIF}
end;

Procedure TfConnectionParameters.CheckEnvGrid;
Begin
  EnvGrid.ColWidths[0]  := pnEnvGrid.ClientWidth -2;
  EnvGrid.FixedRows     := 1;
  pnEnvGrid.ClientHeight:= Min(1+EnvGrid.RowCount*(EnvGrid.DefaultRowHeight+1),
                               Notebook.ClientHeight-gbEnv.Top-pnEnvironment.Height-11);
  gbEnv.ClientHeight    := Max(pnEnvGrid.Height+6*pnEnv.BorderWidth, 75);
  btnEnvDel.Enabled     := (EnvGrid.RowCount>2)or(EnvGrid.Cells[0,EnvGrid.Row]<>'');
End;

procedure TfConnectionParameters.btnEnvNewClick(Sender: TObject);
begin
  EnvGrid.RowCount := EnvGrid.RowCount+1;
  EnvGrid.Cells[0,EnvGrid.RowCount-1]:='';
  CheckEnvGrid;
end;

procedure TfConnectionParameters.btnEnvDelClick(Sender: TObject);
Var
  I : Integer;
begin
  If (EnvGrid.RowCount-1)>EnvGrid.Selection.Top Then Begin
    {Posun vsechny nahoru}
    For I:=EnvGrid.Selection.Top To EnvGrid.RowCount-1 Do
      EnvGrid.Cells[0,I]:=EnvGrid.Cells[0,I+1];
  End;
  {Vymaz posledni bunku}
  EnvGrid.Cells[0,EnvGrid.RowCount-1]:='';
  EnvGrid.RowCount := EnvGrid.RowCount-1;
  {Kdyz je jen jeden radek nemuze byt fixed !?}
  EnvGrid.RowCount := Max(2, EnvGrid.RowCount);
  EnvGrid.FixedRows:= 1;
  {Zkontrolovat velikost pole}
  CheckEnvGrid;
end;

procedure TfConnectionParameters.FormHide(Sender: TObject);
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.FormHide', 'Begin');{$ENDIF}
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.FormHide', 'End');{$ENDIF}
end;


procedure TfConnectionParameters.EnvGridKeyPress(Sender: TObject; var Key: Char);
begin
  CheckEnvGrid;
end;

procedure TfConnectionParameters.EnumPorts;
Type
  TPrinterInfo1Array = Array[0..100000] of TPrinterInfo1;
  TPortInfo2Array = Array[0..100000] of TPortInfo2;
Var
  Needed            : Integer;
  Allocated         : Integer;
  Returned          : Integer;
  I, J, K           : Integer;
  Ports             :^TPortInfo2Array;
  Domains           :^TPrinterInfo1Array;
  DomainsCnt        : Integer;
  PrintServers      :^TPrinterInfo1Array;
  PrintServersCnt   : Integer;
  Handle            : THandle;
  PortName          : String;
  {$IFDEF DEBUGMSG}S : String;{$ENDIF}
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.EnumPorts', 'Begin');{$ENDIF}
  if not Assigned(PortList) then PortList := TStringList.Create
  else PortList.Clear;

  // Scan for local printers
  WinSpool.EnumPorts(nil, 2, nil, 0, Needed, Returned);
  SafeGetMem(Ports, Needed); Allocated:=Needed;
  WinSpool.EnumPorts(nil, 2, Ports, Allocated, Needed, Returned);
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.EnumPorts', Format('Total posible ports count=%d', [Returned]));{$ENDIF}
  for I:=0 to Returned-1 do begin
    PortName := UpperCase(StrPas(Ports[I].pPortName));
    {$IFDEF DEBUGMSG}S:=Format('Found port name=%s', [PortName]);{$ENDIF}
    if ((Pos('COM', PortName)+Pos('LPT', PortName)>0) or (Pos('\\', PortName)=1)) then begin
      {$IFDEF DEBUGMSG}S:=Format('Testing port name=%s', [PortName]);{$ENDIF}
      J:=Length(PortName);
      if J>0 then
        if PortName[J]=':' then SetLength(PortName, J-1);
      {$IFDEF DEBUGMSG}S:=Format('%s/%s', [S, PortName]);{$ENDIF}
      PortName := PortName+#0;
      SetLastError(0);
      Handle := Windows.CreateFile(@PortName[1], GENERIC_WRITE, 0, nil,
        OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
      {$IFDEF DEBUGMSG}S:=Format('%S; handle=%d, err=%d', [S, Handle, GetLastError()]);{$ENDIF}
      {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.EnumPorts', S);{$ENDIF}
      if Handle>0 then PortList.Add(PortName);
      CloseHandle(Handle);
    end else begin
      {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.EnumPorts', Format('Skiping port name=%s', [PortName]));{$ENDIF}
    end;
  end;
  FreeMem(Ports);


  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfConnectionParameters.EnumPorts', 'End');{$ENDIF}
End;

Procedure TfConnectionParameters.PrinterSetPrinterNames(Direct: Boolean; OldSelection: String);
Var
  Old      : String;
Begin
  Old := PrinterName.Items[PrinterName.ItemIndex];
  if Direct then begin
    if not(Assigned(PortList)) then EnumPorts;
    if Length(OldSelection)>2 then
      if (OldSelection[1]='\')and(OldSelection[2]='\') then begin
        if (PortList.IndexOf(OldSelection)=-1) then PortList.Add(OldSelection);
      end;
    PrinterName.Items.Assign(PortList);
  end else begin
    PrinterName.Items.Assign(Printer.Printers);
  end;

  PrinterName.ItemIndex:= StringsFindNearest(PrinterName.Items, Old, False);
End;

procedure TfConnectionParameters.CheckSSLBoxes;
begin
  cbRequireSSL.Enabled := cbEnableSSL.Enabled and cbEnableSSL.Checked and (not cbDirectSSL.Checked);
  cbDirectSSL.Enabled  := cbEnableSSL.Enabled and cbEnableSSL.Checked;
  if cbDirectSSL.Checked then cbRequireSSL.Checked:=True;
  LSSLVersion.Enabled  := cbEnableSSL.Enabled and cbEnableSSL.Checked;
  SSLVersion.Enabled   := cbEnableSSL.Enabled and cbEnableSSL.Checked;
end;


procedure TfConnectionParameters.cbEnableSSLClick(Sender: TObject);
begin
  Check;
end;

procedure TfConnectionParameters.btnBrowseClick(Sender: TObject);
begin
  AllocateDialog(_fNetworkPrinterInDirectModeSelect);
  fNetworkPrinterInDirectModeSelect.PrinterName:=PrinterName.Items[PrinterName.ItemIndex];
  if fNetworkPrinterInDirectModeSelect.ShowModal=mrOk then begin
    PrinterSetPrinterNames(True, fNetworkPrinterInDirectModeSelect.PrinterName);
    PrinterName.ItemIndex:= StringsFindNearest(PrinterName.Items, fNetworkPrinterInDirectModeSelect.PrinterName, False);
  end;
end;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'finalization', '');{$ENDIF}{$ENDIF}
end.
