{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version  : 0.882
Date     : 22.07.98
Dialog   : Select IP, zobrazuje se kdy je na konkrtnm stroji vce jak jedna
           IP adresa
History  : 
TODO     :
-------------------------------------------------------------------------------}
unit SelectIP;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils,
  Classes,  Graphics, Controls, Forms,
  Dialogs,  Grids,    StdCtrls, ExtCtrls,
  WSocket,  Winsock,  STConfig, xForms;

type
  TfSelectIP = class(TxForm)
    pnIP      : TPanel;
    pnIP2     : TPanel;
    IPList    : TStringGrid;
    pnButtons : TPanel;
    btnOk     : TButton;
    btnCancel : TButton;
    procedure FormResize(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure IPListDblClick(Sender: TObject);
  private
    { Private declarations }
    Function RSelectedIP:String;
  public
    { Public declarations }
    property SelectedIP:String read RSelectedIP;
    constructor Create(aOwner:TComponent); override;
    destructor Destroy; override;
    Function ReadMSG:Boolean; override;
  end;

var
  fSelectIP: TfSelectIP;

implementation
{$R *.DFM}
Uses
  kUnits;
Const
  IPaddr    : String = 'IPaddr';
  SymbName  : String = 'SymbName';

procedure TfSelectIP.FormResize(Sender: TObject);
begin
  IPList.ColWidths[0]:=Round(pnIP2.ClientWidth*0.4)-1;
  IPList.ColWidths[1]:=Round(pnIP2.ClientWidth*0.6)-2;
  pnIP2 .Height      :=(IPList.DefaultRowHeight+1)*IPList.RowCount;
end;

procedure TfSelectIP.FormActivate(Sender: TObject);
Var
  I   : Integer;
  Phe : PHostEnt;
begin
  For I:=0 To LocalIPList.Count-1 Do Begin
    IPList.Cells[0, I+1]:=LocalIPList[I];

    IPList.Cells[1, I+1]:='unknown';
    If CFG^.FTP.DNSResolv Then Begin
      phe:=WSocketGetHostByAddr(LocalIPList[I]);
      If Phe<>nil Then IPList.Cells[1, I+1]:=strPas(Phe^.h_Name);
    End;
  End;
  IPList.Cells[0, 0] := IPaddr;
  IPList.Cells[1, 0] := SymbName;
  IPList.RowCount:=LocalIPList.Count+1;
  FormResize(Self);
end;

Function TfSelectIP.RSelectedIP:String;
Begin
  Result:=IPList.Cells[0, IPList.Selection.Top];
End;

procedure TfSelectIP.IPListDblClick(Sender: TObject);
begin
  ModalResult:=mrOk;
end;

Constructor TfSelectIP.Create(aOwner:TComponent);
Begin
  Inherited Create(aOwner);
  Name         := 'fSelectIP';

  SaveSize     := True;
  SavePosition := True;

  ReadINI;
End;

Destructor TfSelectIP.Destroy;
Begin
  WriteINI;

  Inherited Destroy;
End;

Function TfSelectIP.ReadMSG:Boolean;
Begin
  Result:=Inherited ReadMSG;
  If Result Then Begin
    btnOk    .Caption     := ctbtnOk;
    btnCancel.Caption     := ctbtnCancel;
    IPaddr                := ReadMSGString('IPaddr');
    SymbName              := ReadMSGString('SymbName');
  End;
End;


initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuSelectIP, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuSelectIP, 'finalization', '');{$ENDIF}{$ENDIF}
end.
