//tabulator size = 3

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MaxLineLength   1024
#define CommentChar     '#'
int     Verbose =	      1;
#define CodeTableSize   256
#define TableNameLength 15
char    *LATIN_SMALL_LETTER   = "LATIN SMALL LETTER";
char    *LATIN_CAPITAL_LETTER = "LATIN CAPITAL LETTER";

typedef unsigned char Byte;
typedef unsigned int  Word;
typedef unsigned long ULong;
typedef char          TComment[60];

typedef struct {
	Byte                VendorCode;
	Word                Unicode;
	TComment            Comment;
	Byte					  Linked;
}TSourceTableElement;

typedef struct{
	Byte     Name;
	Byte     Table[CodeTableSize];
}TConvertTable;

typedef struct{
	char		inFile[256];
	char     inName[TableNameLength+1];
}TSourceFileElement;

class TSourceTable{
  private:
	Word                ElementCount;
	TSourceTableElement *Elements;
  public:
	char                *Name;
	//TSourceTableElement* & operator [] (Word index){return Get(index);};
	inline TSourceTableElement *Get(Word index);
	void clearLinked();
	inline Word Count();

	TSourceTable(Word InitalElements, char *aName);
	~TSourceTable(){delete[] Elements;}
};

TSourceTableElement *TSourceTable::Get(Word index){
	if(ElementCount<(index+1)){ // need to be realocated
		Elements = (TSourceTableElement *)realloc(Elements, sizeof(TSourceTableElement)*(index+1));
		ElementCount = index+1;
	};

	return(&Elements[index]);
};

void TSourceTable::clearLinked(){
	for(int i=0; i<ElementCount; i++) Elements[i].Linked=0;
};

Word TSourceTable::Count(){
	return(ElementCount);
};

TSourceTable::TSourceTable(Word InitalElements, char *aName){
	ElementCount=InitalElements;
	Name=(char *)malloc(strlen(aName)+1);
	strcpy(Name,aName);

	Elements=new TSourceTableElement[ElementCount];
	memset(Elements, 0, sizeof(TSourceTableElement)*ElementCount);
};

char *strRTrim(char *str){
	while(str[strlen(str)-1]<'\31') str[strlen(str)-1]='\0';
	return str;
};

TSourceTable *loadUnicodeTable(char *fileName, char *Name){
	FILE                *fh;
	char                iline[MaxLineLength];
	char 		           *ps;
	TSourceTable		  *Src;
	TSourceTableElement *SrcT;
	TSourceTableElement *T1;
	int					  index;

	index = 0;
	Src   = new TSourceTable(1, Name);

	fh=fopen(fileName,"r");
	if(Verbose) printf("Loading file \"%s\".\n", fileName);
//	printf("open");
	while(!feof(fh)){
		fgets(iline, sizeof iline, fh);
//		printf("%s", iline);
		if((iline[0]!=CommentChar)&&(strlen(iline)>1)){
			SrcT = Src->Get(index++);
			sscanf(iline, "%x %x", &SrcT->VendorCode, &SrcT->Unicode);
//			printf("%s", iline);
			ps=strRTrim(iline); 
			while (ps[0]!=CommentChar) ps++; ps++;// find comment
			while ((ps[0]==' ')||(ps[0]=='\t')) ps++; // remove first spaces
			strcpy(SrcT->Comment,ps);
			SrcT->Linked=0;
		}; iline[0]=CommentChar; // prevent to no process eof
	};
	fclose(fh);

	int count;
	for(int i=0; i<Src->Count(); i++){
		count=0;
		T1=Src->Get(i);
		for(int j=0; j<Src->Count(); j++)
			if((strcmp(T1->Comment,Src->Get(j)->Comment)==0)&&(!T1->Linked)){
				count++;
				Src->Get(j)->Linked=1;
			};
		if((count>1)&&(Verbose))	printf("!D: 0x%.2x\t0x%.4x\t#%s\n", T1->VendorCode, T1->Unicode, T1->Comment);
	};

	return(Src);
};

TConvertTable *buildConvertTable(TSourceTable *T1, TSourceTable *T2){
	TConvertTable       *CTable;
	unsigned char	    ALTable[CodeTableSize]; // already linked
	int                 i, j;
	TSourceTableElement *Src; // source
	TSourceTableElement *Trg; // target
	int 		    Again;
	int		    AgainC;

	CTable = new TConvertTable;
	memset(ALTable, 0, sizeof(ALTable));

	for(i=0; i<CodeTableSize; i++) CTable->Table[i]=i;

	if (Verbose) printf("Building table \"%s(%d)=>%s(%d)\".\n", T1->Name, T1->Count(),
																					T2->Name, T2->Count());
	T1->clearLinked();

	for(i=0; i<T1->Count(); i++){
		Src = T1->Get(i);

		Again=!ALTable[Src->VendorCode];

		AgainC=0;
		while(Again){
			Again=0;

			// Try to search exactly
			for(j=0; j<T2->Count(); j++){
				Trg = T2->Get(j);
				if(strcmp(Src->Comment,Trg->Comment)==0){
					ALTable[Src->VendorCode]=Src->Linked=1;
					CTable->Table[Src->VendorCode]=Trg->VendorCode;
					if (Verbose) printf(" L: 0x%.2x=>0x%.2x\t0x%.4x\t#%s\n",
						Src->VendorCode,
						Trg->VendorCode,
						Src->Unicode,
						Src->Comment);
					break; // found skip it for
				};
			};

			// Try to search similar
			if(!Src->Linked){

				if(strncmp(Src->Comment, LATIN_CAPITAL_LETTER, strlen(LATIN_CAPITAL_LETTER))==0){
					Src->Comment[strlen(LATIN_CAPITAL_LETTER)+2]='\0';
					if (!AgainC) Again=1;
					AgainC++; 
				};

				if(strncmp(Src->Comment, LATIN_SMALL_LETTER, strlen(LATIN_SMALL_LETTER))==0){
					Src->Comment[strlen(LATIN_SMALL_LETTER)+2]='\0';
					if (!AgainC) Again=1;
					AgainC++;
				};
			};
		}

		//print not linked chars
		if((!Src->Linked)&&(Verbose)) printf("!U: 0x%.2x\t0x%.4x\t#%s\n",
			Src->VendorCode,
			Src->Unicode,
			Src->Comment);

	};


	return(CTable);
};

TConvertTable *doConvertTable(char *file1, char *name1, char *file2, char *name2){
	TSourceTable  *T1;
	TSourceTable  *T2;
	TConvertTable *CT;

	T1 = loadUnicodeTable(file1, name1);
	T2 = loadUnicodeTable(file2, name2);

	CT = buildConvertTable(T1, T2);
	delete T1;
	delete T2;

	return(CT);
};


void main(){
	FILE 						*fh;
	TSourceFileElement   *Source;
	TConvertTable 			*ConvertTable;
	unsigned char   		Count;
	unsigned int			i,j;
	char						iLine[512];
	char						*p;


	// read tables from file as is written in TABLES.DEF
	fh=fopen("TABLES.DEF", "rt");
	fscanf(fh, "%du", &Count); fgets(iLine, 512, fh);
	Source = new TSourceFileElement[Count];
	memset(Source, 0, Count*sizeof(TSourceFileElement));

	for(i=0; i<Count; i++){
		fgets(iLine, 512, fh); strRTrim(iLine);
		strcpy((Source+i)->inFile, iLine);

		for(j=0; j<strlen((Source+i)->inFile); j++) if((Source+i)->inFile[j]==' ') {
			(Source+i)->inFile[j]='\0';
			p=&iLine[j+1];
			while(p[0]==' ') p++;
		};
		strcpy((Source+i)->inName, p);
	}
	fclose(fh);


	// build and write convert tables to file
	fh=fopen("TABLES.BIN", "wb");
	fwrite(&Count,1,1,fh);
	for(i=0; i<Count; i++) fwrite(&((Source+i)->inName),1,TableNameLength, fh);
	for(i=0; i<Count; i++)
		for(j=0; j<Count; j++) if(i!=j){
			ConvertTable=doConvertTable((Source+i)->inFile, (Source+i)->inName,
												 (Source+j)->inFile, (Source+j)->inName);
			fwrite(&ConvertTable->Table, 1, CodeTableSize, fh);
			delete ConvertTable;
		};
	fclose(fh);


	delete[] Source;
}
