unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Timer1: TTimer;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    winList: TMemo;
    Edit1: TEdit;
    procedure Timer1Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
Uses
  Win2Tree;
Var
  wList : TMemo;


function GetIcon(Handle:HWND;Big:Boolean):Longint;
begin
  Result:=0;

  // Try to use class long. Only from few apps is posible to get icon
  // with this function.
  If Big Then Result:=GetClassLong(Handle, GCL_HICON)
  Else {If not WinNT Then}Result:=GetClassLong(Handle, GCL_HICONSM);

  // This function isn't suported by Windows NT (3.5, 4.xx ...?)
  If Result=0 Then Result:=DefWindowProc(Handle, WM_GETICON, Integer(Big), 0);
end;

Procedure RecursivePrint(Element: PWin2TreeElement; Const Space:String);
Var
  I : Integer;
Begin
  wList.Lines.Add(Format('%s%5d: %s:%s [%d:%d %d:%d], ICON=%d, %d',
    [Space, Element^.Handle, Element^.WClass, Element^.Title,
     Element^.Rect.Left, Element^.Rect.Top,
     Element^.Rect.Right, Element^.Rect.Bottom,
     GetIcon(Element^.Handle, not Form1.CheckBox1.Checked), GetLastError]));
  If Element^.Childs<>nil Then For I:=0 To Element^.Childs.Count-1 Do
    RecursivePrint(Element^.Childs[I], Space+'     ');
End;

procedure TForm1.Timer1Timer(Sender: TObject);
Var
  Root  : PWin2TreeElement;
begin
  Timer1.Enabled:=False;
  Caption:=Format('App=%d, Form=%d', [Application.Handle, Handle]);
  MessageBeep(0);
  wList:=winList;
  wList.Clear;
  Root:=LoadTree;

  RecursivePrint(Root, '');

  DestroyTree(Root);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Timer1.Enabled:=True;
end;

procedure TForm1.Button2Click(Sender: TObject);
Var
  B : LongBool;
  I : Integer;
  H : HICON;
  II: TICONINFO;
begin
  H:=StrToInt(Edit1.Text);
  B:=GetIconInfo(H, II);
  B:=BitBlt(Form1.Canvas.Handle, Panel2.Left+20, 200, 10, 10,
            Form1.Canvas.Handle, 10, 10, SRCCOPY);
  I:=GetLastError;
end;

end.
