unit DebugW;

interface

Procedure DebugWAddEString(const EAssertionFailedMsg, format: String;
                           x: Array of const);
                           
Procedure DebugWAddString(const mfile: String; const mline: Integer;
                          const format: String; x: Array of const);
implementation
Uses
  Windows, Forms, Messages, SysUtils;

Const
  dest: HWND = 0;
Var
  cds   : TCopyDataStruct;
  dout  : String;
  dum   : String;
  mfile : String;
  mline : Integer;
  I     : Integer;

Procedure DebugWAddEString(const EAssertionFailedMsg, format: String;
                           x: Array of const);
Begin
  If dest = Application.Handle Then Exit;

  dum := EAssertionFailedMsg;
  Delete(dum, 1, Pos('(', dum));
  Delete(dum, Pos(')', dum), 1024); // FUJ ale mozna to usetri par instrukci
  I:=Pos(', line ', dum);
  mfile := Copy(dum, 1, I-1); Delete(dum, 1, I+Length(', line ')-1);
  try mline := StrToInt(dum); except on  EConvertError do; end;

  DebugWAddString(mfile, mline, format, x);
End;

Function MyDateTimeToStr(DT: TDateTime): String;
Var
  Hour, Min, Sec, MSec: Word;
Begin
  DecodeTime(DT, Hour, Min, Sec, MSec);
  Result := Format('%s %d:%d:%d:%d', [DateToStr(DT), Hour, Min, Sec, MSec]);
End;

Procedure DebugWAddString(const mfile: String; const mline: Integer;
                          const format: String; x: Array of const);
Begin
  If dest = Application.Handle Then Exit;

  If dest = 0 Then Begin
    dest := FindWindow('Ray''s message debuging class', nil);
    If dest = 0 Then dest := Application.Handle;
  End;

  dout := SysUtils.Format('%s|%s|%d|%s'#0, [SysUtils.Format(format, x),
             mfile, mline, MyDateTimeToStr(Now)]);
  cds.dwData := 0;
  cds.cbData := Length(dout)-1; // -1 because #0 is valid char
  cds.lpData := @dout[1];

  SendMessage(dest, WM_COPYDATA, 0, Integer(@cds));
End;

(* ----------------------------------------------------------------------------
  Original Unreal's code


void __stdcall DebugWAddString(char* mfile,int mline,char* mdate,char* format,...) {

  static COPYDATASTRUCT cds;
  static HWND           dest=NULL;
  static TCHAR*         d;
  static TCHAR          msgbuf[512];
  static TCHAR          msgbuf2[512];
  static int            x;
  static TCHAR          out[512];

  va_list               arglist;


  if (dest==(HWND)-1)
      return;

  if (!dest) {
    dest=FindWindow("Ray's message debuging class",NULL);
    if (!dest) {
        dest=(HWND)-1;
        return;
    }
  }

  va_start( arglist, format );
  vsprintf(msgbuf, format, arglist );
  va_end( arglist );
  if (msgbuf[strlen(msgbuf)-1]=='\n') msgbuf[strlen(msgbuf)-1]=0;
  while (NULL!=(d=strchr(msgbuf,'\n'))) {
     memcpy(msgbuf2,msgbuf,d-msgbuf);
     msgbuf2[d-msgbuf]=0;

     sprintf(out,"%s|%s|%c|%s",msgbuf2,mfile,mline,mdate);
     rINITSTRUCT(cds,FALSE);
     cds.dwData=0;
     cds.cbData=strlen(out)+1;
     cds.lpData=out;
     FORWARD_WM_COPYDATA(dest,NULL,&cds,SendMessage);

     _tcscpy(msgbuf,d+1);
  }

  sprintf(out,"%s|%s|%d|%s",msgbuf,mfile,mline,mdate);
  rINITSTRUCT(cds,FALSE);
  cds.dwData=0;
  cds.cbData=strlen(out)+1;
  cds.lpData=out;
  FORWARD_WM_COPYDATA(dest,NULL,&cds,SendMessage);

}
----------------------------------------------------------------------------- *)

end.
