unit Config;

interface
Uses
  ComCtrls, Classes, Graphics, Sticky;

Const
  MaxDesktop = 99;

Type
  TsDeskAlign = (sDeskTOP, sDeskBOTTOM, sDeskLEFT, sDeskRIGHT);
  TsDeskSSaver = (sDeskLEFTTOP, sDeskRIGHTTOP, sDeskRIGHTBOTTOM, sDeskLEFTBOTTOM);
  TsDeskSwitchMode = (sDeskSwitchNONE, sDeskSwitchAUTO, sDeskSwitchMANUAL);
  TsDeskSwitchKey  = (sDeskSwitchALT, sDeskSwitchSHIFT, sDeskSwitchCTRL);
  TsDeskCFGWindow = record
    Columns, Rows      : Integer;          // Count of desktops
    Left, Top          : Integer;
    xStep, yStep       : Integer;          // Dimmensions of one desktop
    NotHide            : Boolean;          // Allow window hiding
    Docking            : Boolean;
    DockingPos         : TsDeskAlign;      // Position where window will be hiden
    VisiblePart        : Integer;          // Valid only if Hide=1
    SmoothHiding       : Boolean;
    AllowMoveMaximized : Boolean;
    MoveTimeout        : Integer;
    { 11.07.1999 Added by Tim Boughen }
    PagerTitle         : String;
    ShowDesktopNumbers : Boolean;
    ShowTitleBar       : Boolean;
    ActiveColor        : Integer;
    InactiveColor      : Integer;
    GridColor          : Integer;
    { End Tim }
    TitleChangeAllowed : Boolean;
  End;
  TsDeskCFGScreenSaver = record
    Allowed         : Boolean;          // Is allowed screen saver activation
    AllowRerun      : Boolean;
    ActivationPos   : TsDeskSSaver;     // Where to activate screen saver
    ActivationTime  : Integer;          //
    RunFile         : Boolean;          // Run specified file instead system screen saver
    RunFileName     : ShortString;      // Name of file ...
    RunFileArgs     : ShortString;      // Arguments of file
    Sensitivity     : Integer;
  End;
  TsDeskCFGDesktopSwitching = record
    SwitchMode      : TsDeskSwitchMode;
    SwitchKey       : TsDeskSwitchKey;
    SwitchHotHey    : Integer;
    { 16.07.99 Added by Tim Boughen }
    HideApps        : Boolean;
    ResetApps       : Boolean;
    { end Tim }
    MouseSwEnabled  : Boolean;
    MouseSwSens     : Integer;
    MouseSwSpeed    : Integer;
    MouseSwMoveCur  : Boolean;
  End;
  TsDeskCFGGeneral = record
    ContextMenu       : Integer;
    HideFromTaskBar   : Boolean;
    PutIconToTray     : Boolean;
    CycleDesktops     : Boolean;
    MoveToFirst       : Boolean;
    { 19/07/99 added by Tim Boughen }
    CycleSingleRow    : Boolean;
    { end Tim}
  End;
  TsDeskCFGHotkeys = record
    DeskPlus        : Integer;
    DeskMinus       : Integer;
    DeskPlusRow     : Integer;
    DeskMinusRow    : Integer;
    DeskDirect      : Array[0..MaxDesktop-1] of Integer;
  End;
  TsDeskCFGStickyWindows = record
    List       : TStickyWindows;
    LastMode   : TStickyElementMode;
  End;
  TsDeskCFGDesktopNames = record
    Enabled : Boolean;
    Names   : TStringList;
    Delay   : Integer;
  end;
  TsDeskCFG = record
    General          : TsDeskCFGGeneral;
    HotKeys          : TsDeskCFGHotkeys;
    Window           : TsDeskCFGWindow;
    ScreenSaver      : TsDeskCFGScreenSaver;
    DesktopSwitching : TsDeskCFGDesktopSwitching;
    StickyWindows    : TsDeskCFGStickyWindows;
    DesktopNames     : TsDeskCFGDesktopNames;
  End;

Var
  CFG          : TsDeskCFG;
  SwitchToDesk : Integer;

  CFGdefault : TsDeskCFG = (
    General: (
      ContextMenu         : 0;
      HideFromTaskBar     : True;
      PutIconToTray       : True;
      CycleDesktops       : True;
      MoveToFirst         : False;
      CycleSingleRow      : True;
    );
    HotKeys: (
    );
    Window: (
      Columns             : 4;
      Rows                : 3;
      Left                : 200;
      Top                 : 200;
      xStep               : 30;
      yStep               : 25;
      NotHide             : False;
      Docking             : True;
      DockingPos          : sDeskRIGHT;
      VisiblePart         : 5;
      SmoothHiding        : True;
      AllowMoveMaximized  : False;
      MoveTimeout         : 150;
      { 11.07.1999 Added by Tim Boughen }
      PagerTitle          : 'Semik''s desktop';
      ShowDesktopNumbers  : True;
      ShowTitleBar        : True;
      ActiveColor         : clInactiveCaption;
      InactiveColor       : clBtnFace;
      GridColor           : clBlack;
      { End Tim }
      TitleChangeAllowed  : False;
    );
    ScreenSaver: (
      Allowed             : True;
      AllowRerun          : False;
      ActivationPos       : sDeskRIGHTTOP;
      ActivationTime      : 5000;
      RunFile             : False;
      RunFileName         : '';
      RunFileArgs         : '';
      Sensitivity         : 2;
    );
    DesktopSwitching: (
      SwitchMode     : sDeskSwitchMANUAL;
      SwitchKey      : sDeskSwitchCTRL;
      { 16.07.99 Added by Tim Boughen }
      HideApps       : False;
      ResetApps      : False;
      { End Tim }
      MouseSwEnabled : True;
      MouseSwSens    : 1;
      MouseSwSpeed   : 600;
      MouseSwMoveCur : True;
    );
    StickyWindows: (
      List      : nil;
    );
    DesktopNames: (
      Enabled   : True;
      Names     : nil;
      Delay     : 1000;
    );
  );

Const
  DockingStep : Integer = 10;
  Version               = '1.2.0';

function ReadCFG:TsDeskCFG;
procedure WriteCFG(xData:TsDeskCFG);

implementation
Uses
  Registry, SysUtils, Menus, StickyProp;

Const
  RegKey           = 'Software\Jan Tomasek\sDesk';

Function ReadInteger(reg:TRegistry; Const Name:String;Def:Integer):Integer;
Begin try
  result:=reg.ReadInteger(Name);
except
  on ERegistryException do result:=Def
end End;

Function ReadBool(reg:TRegistry; Const Name:String;Def:Boolean):Boolean;
Begin try
  result:=reg.ReadBool(Name);
except
  on ERegistryException do result:=Def
end End;

Function ReadString(reg:TRegistry; Const Name:String;Def:String):String;
Begin try
  result:=reg.ReadString(Name);
except
  result:=Def
end End;

function ReadCFG:TsDeskCFG;
Var
  reg    : TRegistry;
  xData  : TsDeskCFG;
  I      : Integer;
begin
  // load configuration
  reg := TRegistry.Create;
  reg.OpenKey(regKey, True);

  // Safe!!!
  xData := CFG;

  // general
  xData.General.HideFromTaskBar    :=              ReadBool   (reg, 'General.HideFromTaskBar',           CFGdefault.General.HideFromTaskBar);
  xData.General.PutIconToTray      :=              ReadBool   (reg, 'General.PutIconToTray',             CFGdefault.General.PutIconToTray);
  xData.General.CycleDesktops      :=              ReadBool   (reg, 'General.CycleDesktops',             CFGdefault.General.CycleDesktops);
  xData.General.ContextMenu        :=              ReadInteger(reg, 'General.ContextMenu',               CFGdefault.General.ContextMenu);
  { 19/07/99 Added by Tim Boughen }
  xData.General.CycleSingleRow     :=              ReadBool   (reg, 'General.CycleSingleRow',            CFGdefault.General.CycleSingleRow);
  { End Tim }
  xData.General.MoveToFirst        :=              ReadBool   (reg, 'General.MoveToFirst',               CFGdefault.General.MoveToFirst);
  // hotkeys
  xData.HotKeys.DeskPlus           :=              ReadInteger(reg, 'HotKeys.DeskPlus',                  CFGdefault.HotKeys.DeskPlus);
  xData.HotKeys.DeskMinus          :=              ReadInteger(reg, 'HotKeys.DeskMinus',                 CFGdefault.HotKeys.DeskMinus);
  xData.HotKeys.DeskPlusRow        :=              ReadInteger(reg, 'HotKeys.DeskPlusRow',               CFGdefault.HotKeys.DeskPlusRow);
  xData.HotKeys.DeskMinusRow       :=              ReadInteger(reg, 'HotKeys.DeskMinusRow',              CFGdefault.HotKeys.DeskMinusRow);
  For I:=0 To MaxDesktop-1 Do
    xData.HotKeys.DeskDirect[I]    :=              ReadInteger(reg, Format('HotKeys.DeskDirect.%d', [I]),CFGdefault.HotKeys.DeskDirect[I]);
  // load window's cfg
  xData.Window.Columns             :=              ReadInteger(reg, 'Window.Columns',                    CFGdefault.Window.Columns);
  xData.Window.Rows                :=              ReadInteger(reg, 'Window.Rows',                       CFGdefault.Window.Rows);
  xData.Window.Left                :=              ReadInteger(reg, 'Window.Left',                       CFGdefault.Window.Left);
  xData.Window.Top                 :=              ReadInteger(reg, 'Window.Top',                        CFGdefault.Window.Top);
  xData.Window.xStep               :=              ReadInteger(reg, 'Window.xStep',                      CFGdefault.Window.xStep);
  xData.Window.yStep               :=              ReadInteger(reg, 'Window.yStep',                      CFGdefault.Window.yStep);
  xData.Window.NotHide             :=              ReadBool   (reg, 'Window.NotHide',                    CFGdefault.Window.NotHide);
  xData.Window.Docking             :=              ReadBool   (reg, 'Window.Docking',                    CFGdefault.Window.Docking);
  xData.Window.DockingPos          :=  TsDeskAlign(ReadInteger(reg, 'Window.DockingPos',         Integer(CFGdefault.Window.DockingPos)));
  xData.Window.VisiblePart         :=              ReadInteger(reg, 'Window.VisiblePart ',               CFGdefault.Window.VisiblePart);
  xData.Window.SmoothHiding        :=              ReadBool   (reg, 'Window.SmoothHiding',               CFGdefault.Window.SmoothHiding);
  xData.Window.AllowMoveMaximized  :=              ReadBool   (reg, 'Window.AllowMoveMaximized',         CFGdefault.Window.AllowMoveMaximized);
  xData.Window.MoveTimeout         :=              ReadInteger(reg, 'Window.MoveTimeout',                CFGdefault.Window.MoveTimeout);
  { 11.07.1999 Added by Tim Boughen }
  xData.Window.PagerTitle          :=              ReadString (reg, 'Window.PagerTitle',                 CFGdefault.Window.PagerTitle);
    If xData.Window.PagerTitle='' Then xData.Window.PagerTitle:=CFGdefault.Window.PagerTitle;
  xData.Window.ShowDesktopNumbers  :=              ReadBool   (reg, 'Window.ShowDesktopNumbers',         CFGdefault.Window.ShowDesktopNumbers);
  xData.Window.ShowTitleBar        :=              ReadBool   (reg, 'Window.ShowTitleBar',               CFGdefault.Window.ShowTitleBar);
  xData.Window.ActiveColor         :=              ReadInteger(reg, 'Window.ActiveColor',                CFGdefault.Window.ActiveColor);
  xData.Window.InactiveColor       :=              ReadInteger(reg, 'Window.InactiveColor',              CFGdefault.Window.InactiveColor);
  xData.Window.GridColor           :=              ReadInteger(reg, 'Window.GridColor',                  CFGdefault.Window.GridColor);
  { End Tim }
  xData.Window.TitleChangeAllowed  :=              ReadBool   (reg, 'Window.TitleChangeAllowed',         CFGdefault.Window.TitleChangeAllowed);
    If not xData.Window.TitleChangeAllowed Then xData.Window.PagerTitle:=CFGdefault.Window.PagerTitle;
  // load screen saver ...
  xData.ScreenSaver.Allowed        :=              ReadBool   (reg, 'ScreenSaver.Allowed',               CFGdefault.ScreenSaver.Allowed);
  xData.ScreenSaver.AllowRerun     :=              ReadBool   (reg, 'ScreenSaver.AllowRerun',            CFGdefault.ScreenSaver.AllowRerun);
  xData.ScreenSaver.ActivationPos  := TsDeskSSaver(ReadInteger(reg, 'ScreenSaver.ActivationPos', Integer(CFGdefault.ScreenSaver.ActivationPos)));
  xData.ScreenSaver.ActivationTime :=              ReadInteger(reg, 'ScreenSaver.ActivationTime',        CFGdefault.ScreenSaver.ActivationTime);
  xData.ScreenSaver.RunFile        :=              ReadBool   (reg, 'ScreenSaver.RunFile',               CFGdefault.ScreenSaver.RunFile);
  xData.ScreenSaver.RunFileName    :=              ReadString (reg, 'ScreenSaver.RunFileName',           CFGdefault.ScreenSaver.RunFileName);
  xData.ScreenSaver.RunFileArgs    :=              ReadString (reg, 'ScreenSaver.RunFileArgs',           CFGdefault.ScreenSaver.RunFileArgs);
  xData.ScreenSaver.Sensitivity    :=              ReadInteger(reg, 'ScreenSaver.Sensitivity',           CFGdefault.ScreenSaver.Sensitivity);

  // desktop switching
  xData.DesktopSwitching.SwitchMode    :=TsDeskSwitchMode(ReadInteger(reg, 'DesktopSwitching.Mode',   Integer(CFGdefault.DesktopSwitching.SwitchMode)));
  xData.DesktopSwitching.SwitchKey     :=TsDeskSwitchKey (ReadInteger(reg, 'DesktopSwitching.Key',    Integer(CFGdefault.DesktopSwitching.SwitchKey)));
  xData.DesktopSwitching.SwitchHotHey :=                 ReadInteger(reg, 'DesktopSwitching.HotKey', CFGdefault.DesktopSwitching.SwitchHotHey);
  { 16.07.99 Added by Tim Boughen }
  xData.DesktopSwitching.HideApps      :=            ReadBool   (reg, 'DesktopSwitching.HideApps',         CFGdefault.DesktopSwitching.HideApps);
  xData.DesktopSwitching.ResetApps     :=            ReadBool   (reg, 'DesktopSwitching.ResetApps',        CFGdefault.DesktopSwitching.ResetApps);
  { End Tim }
  xData.DesktopSwitching.MouseSwEnabled:=            ReadBool   (reg, 'DesktopSwitching.MouseSwEnabled',    CFGdefault.DesktopSwitching.MouseSwEnabled);
  xData.DesktopSwitching.MouseSwSens   :=            ReadInteger(reg, 'DesktopSwitching.MouseSwSens',       CFGdefault.DesktopSwitching.MouseSwSens);
  xData.DesktopSwitching.MouseSwSpeed  :=            ReadInteger(reg, 'DesktopSwitching.MouseSwSpeed',      CFGdefault.DesktopSwitching.MouseSwSpeed);
  xData.DesktopSwitching.MouseSwMoveCur:=            ReadBool   (reg, 'DesktopSwitching.MouseSwMoveCur',    CFGdefault.DesktopSwitching.MouseSwMoveCur);

  // Sticky windows
  xData.StickyWindows.LastMode := TStickyElementMode(ReadInteger(reg, 'StickyWindows.LastMode', Integer(semEXPR)));
  CFG.StickyWindows.List.Load(reg);
  // desktop names
  xData.DesktopNames.Enabled   := ReadBool   (reg, 'DesktopNames.Enabled', CFGdefault.DesktopNames.Enabled);
  xData.DesktopNames.Delay     := ReadInteger(reg, 'DesktopNames.Delay', CFGdefault.DesktopNames.Delay);
  xData.DesktopNames.Names.Clear;     
  for I:=0 to CFG.Window.Rows*CFG.Window.Columns-1 do begin
    xData.DesktopNames.Names.Add(ReadString(reg, Format('DesktopNames.%d', [I]), ''));
    if xData.DesktopNames.Names[I]='' then
      xData.DesktopNames.Names[I] := Format('Desktop %d', [I+1]);
  end;

  reg.Free;

  result := xData;
end;

procedure WriteCFG(xData:TsDeskCFG);
Var
  reg    : TRegistry;
  I      : Integer;
begin
  // write configuration
  reg := TRegistry.Create;
  reg.OpenKey(regKey, True);

  // general
  reg.WriteBool   ('General.HideFromTaskBar',           xData.General.HideFromTaskBar);
  reg.WriteBool   ('General.PutIconToTray',             xData.General.PutIconToTray);
  reg.WriteBool   ('General.CycleDesktops',             xData.General.CycleDesktops);
  { 19/07/99 Added by Tim Boughen }
  reg.WriteBool   ('General.CycleSingleRow',            xData.General.CycleSingleRow);
  { End Tim }
  reg.WriteInteger('General.ContextMenu',               xData.General.ContextMenu);
  reg.WriteBool   ('General.MoveToFirst',               xData.General.MoveToFirst);
  // hotkeys
  reg.WriteInteger('HotKeys.DeskPlus',                  xData.HotKeys.DeskPlus);
  reg.WriteInteger('HotKeys.DeskMinus',                 xData.HotKeys.DeskMinus);
  reg.WriteInteger('HotKeys.DeskPlusRow',               xData.HotKeys.DeskPlusRow);
  reg.WriteInteger('HotKeys.DeskMinusRow',              xData.HotKeys.DeskMinusRow);
  For I:=0 To MaxDesktop-1 Do If xData.HotKeys.DeskDirect[I]<>0 Then
  reg.WriteInteger(Format('HotKeys.DeskDirect.%d', [I]),xData.HotKeys.DeskDirect[I]);
  // window's cfg
  reg.WriteInteger('Window.Columns',                    xData.Window.Columns);
  reg.WriteInteger('Window.Rows',                       xData.Window.Rows);
  reg.WriteInteger('Window.Left',                       xData.Window.Left);
  reg.WriteInteger('Window.Top',                        xData.Window.Top);
  reg.WriteInteger('Window.xStep',                      xData.Window.xStep);
  reg.WriteInteger('Window.yStep',                      xData.Window.yStep);
  reg.WriteBool   ('Window.NotHide',                    xData.Window.NotHide);
  reg.WriteBool   ('Window.Docking',                    xData.Window.Docking);
  reg.WriteInteger('Window.DockingPos',         Integer(xData.Window.DockingPos));
  reg.WriteInteger('Window.VisiblePart ',               xData.Window.VisiblePart);
  reg.WriteBool   ('Window.SmoothHiding',               xData.Window.SmoothHiding);
  reg.WriteBool   ('Window.AllowMoveMaximized',         xData.Window.AllowMoveMaximized);
  reg.WriteInteger('Window.MoveTimeout',                xData.Window.MoveTimeout);
  { 11.07.1999 Added by Tim Boughen }
  reg.WriteString ('Window.PagerTitle',                 xData.Window.PagerTitle);
  reg.WriteBool   ('Window.ShowDesktopNumbers',         xData.Window.ShowDesktopNumbers);
  reg.WriteBool   ('Window.ShowTitleBar',               xData.Window.ShowTitleBar);
  reg.WriteInteger('Window.ActiveColor',                xData.Window.ActiveColor);
  reg.WriteInteger('Window.InactiveColor',              xData.Window.InactiveColor);
  reg.WriteInteger('Window.GridColor',                  xData.Window.GridColor);
  { end Tim }

  // screen saver ...
  reg.WriteBool   ('ScreenSaver.Allowed',               xData.ScreenSaver.Allowed);
  reg.WriteBool   ('ScreenSaver.AllowRerun',            xData.ScreenSaver.AllowRerun);
  reg.WriteInteger('ScreenSaver.ActivationPos', Integer(xData.ScreenSaver.ActivationPos));
  reg.WriteInteger('ScreenSaver.ActivationTime',        xData.ScreenSaver.ActivationTime);
  reg.WriteBool   ('ScreenSaver.RunFile',               xData.ScreenSaver.RunFile);
  reg.WriteString ('ScreenSaver.RunFileName',           xData.ScreenSaver.RunFileName);
  reg.WriteString ('ScreenSaver.RunFileArgs',           xData.ScreenSaver.RunFileArgs);
  reg.WriteInteger('ScreenSaver.Sensitivity',           xData.ScreenSaver.Sensitivity);
  // desktop switching
  reg.WriteInteger('DesktopSwitching.Mode',     Integer(xData.DesktopSwitching.SwitchMode));
  reg.WriteInteger('DesktopSwitching.Key',      Integer(xData.DesktopSwitching.SwitchKey));
  reg.WriteInteger('DesktopSwitching.HotKey',           xData.DesktopSwitching.SwitchHotHey);
  { 16.07.99 Added by Tim Boughen }
  reg.WriteBool   ('DesktopSwitching.HideApps',         xData.DesktopSwitching.HideApps);
  reg.WriteBool   ('DesktopSwitching.ResetApps',        xData.DesktopSwitching.ResetApps);
  { End Tim }
  reg.WriteBool   ('DesktopSwitching.MouseSwEnabled',   xData.DesktopSwitching.MouseSwEnabled);
  reg.WriteInteger('DesktopSwitching.MouseSwSens',      xData.DesktopSwitching.MouseSwSens);
  reg.WriteInteger('DesktopSwitching.MouseSwSpeed',     xData.DesktopSwitching.MouseSwSpeed);
  reg.WriteBool   ('DesktopSwitching.MouseSwMoveCur',   xData.DesktopSwitching.MouseSwMoveCur);

  // Sticky windows
  reg.WriteInteger('StickyWindows.LastMode', Integer(xData.StickyWindows.LastMode));
  CFG.StickyWindows.List.Save(reg);
  // desktop names
  reg.WriteBool   ('DesktopNames.Enabled', xData.DesktopNames.Enabled);
  reg.WriteInteger('DesktopNames.Delay', xData.DesktopNames.Delay);
  for I:=0 to xData.DesktopNames.Names.Count-1 do
    reg.WriteString(Format('DesktopNames.%d', [I]), xData.DesktopNames.Names[i]);

  reg.Free;
end;

Var
  I: Integer;
initialization
  SwitchToDesk := -1;

  For I:=0 To MaxDesktop-1 Do CFGdefault.HotKeys.DeskDirect[I]:=0;
  CFGdefault.General.ContextMenu  := TextToShortCut('ALT+CTRL+HOME');
  CFGdefault.HotKeys.DeskPlus     := TextToShortCut('ALT+CTRL+RIGHTARROW');
  CFGdefault.HotKeys.DeskMinus    := TextToShortCut('ALT+CTRL+LEFTARROW');
  CFGdefault.HotKeys.DeskPlusRow  := TextToShortCut('ALT+CTRL+DOWNARROW');
  CFGdefault.HotKeys.DeskMinusRow := TextToShortCut('ALT+CTRL+UPARROW');
  CFGdefault.HotKeys.DeskDirect[0]:= TextToShortCut('ALT+CTRL+F1')+0;
  CFGdefault.HotKeys.DeskDirect[1]:= TextToShortCut('ALT+CTRL+F1')+1;
  CFGdefault.HotKeys.DeskDirect[2]:= TextToShortCut('ALT+CTRL+F1')+2;
  CFGdefault.HotKeys.DeskDirect[3]:= TextToShortCut('ALT+CTRL+F1')+3;
  CFGdefault.HotKeys.DeskDirect[4]:= TextToShortCut('ALT+CTRL+F1')+4;
  CFGdefault.HotKeys.DeskDirect[5]:= TextToShortCut('ALT+CTRL+F1')+5;
  CFGdefault.HotKeys.DeskDirect[6]:= TextToShortCut('ALT+CTRL+F1')+6;
  CFGdefault.HotKeys.DeskDirect[7]:= TextToShortCut('ALT+CTRL+F1')+7;
  CFGdefault.HotKeys.DeskDirect[8]:= TextToShortCut('ALT+CTRL+F1')+8;
  CFGdefault.HotKeys.DeskDirect[9]:= TextToShortCut('ALT+CTRL+F1')+9;
  CFGdefault.HotKeys.DeskDirect[10]:=TextToShortCut('ALT+CTRL+F1')+10;
  CFGdefault.HotKeys.DeskDirect[11]:=TextToShortCut('ALT+CTRL+F1')+11;
  CFG := CFGdefault;
  CFG.StickyWindows.List := TStickyWindows.Create;
  CFG.DesktopNames.Names := TStringList.Create;
end.
